/*
 * Decompiled with CFR 0.152.
 */
package difflib.event;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import difflib.DiffUtils;
import difflib.Patch;
import difflib.event.PatchHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class UnifiedPatchParser {
    public void parse(File unifiedPatch, @Nonnull PatchHandler<String> handler) throws FileNotFoundException, IOException {
        try (BufferedReader reader = Files.newReader((File)unifiedPatch, (Charset)Charsets.UTF_8);){
            String line = reader.readLine();
            do {
                ArrayList patch = Lists.newArrayList();
                while (!line.startsWith("---")) {
                    line = reader.readLine();
                }
                assert (line.startsWith("---"));
                patch.add(line);
                String originalFileName = line.substring(4);
                line = reader.readLine();
                assert (line.startsWith("+++"));
                patch.add(line);
                String revisedFileName = line.substring(4);
                line = reader.readLine();
                do {
                    patch.add(line);
                } while ((line = reader.readLine()) != null && (line.startsWith("@@ ") || line.startsWith(" ") || line.startsWith("+") || line.startsWith("-")));
                Patch<String> parsed = DiffUtils.parseUnifiedDiff(patch);
                handler.handle(originalFileName, revisedFileName, parsed);
            } while (line != null);
        }
    }
}

