/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DiffRow {
    @Nonnull
    private Tag tag;
    @Nullable
    private String oldLine;
    @Nullable
    private String newLine;

    public DiffRow(@Nonnull Tag tag, @Nullable String oldLine, @Nullable String newLine) {
        this.tag = (Tag)((Object)Preconditions.checkNotNull((Object)((Object)tag)));
        this.oldLine = oldLine;
        this.newLine = newLine;
    }

    @Nonnull
    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    @Nullable
    public String getOldLine() {
        return this.oldLine;
    }

    public void setOldLine(@Nullable String oldLine) {
        this.oldLine = oldLine;
    }

    @Nullable
    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(@Nullable String newLine) {
        this.newLine = newLine;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.newLine == null ? 0 : this.newLine.hashCode());
        result = 31 * result + (this.oldLine == null ? 0 : this.oldLine.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiffRow other = (DiffRow)obj;
        if (this.newLine == null ? other.newLine != null : !this.newLine.equals(other.newLine)) {
            return false;
        }
        if (this.oldLine == null ? other.oldLine != null : !this.oldLine.equals(other.oldLine)) {
            return false;
        }
        return !(this.tag == null ? other.tag != null : !this.tag.equals((Object)other.tag));
    }

    public String toString() {
        return "[" + (Object)((Object)this.tag) + "," + this.oldLine + "," + this.newLine + "]";
    }

    public static enum Tag {
        INSERT,
        DELETE,
        CHANGE,
        EQUAL;

    }
}

