/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import com.google.common.base.Preconditions;
import difflib.PatchFailedException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnegative;

public class Chunk<T> {
    @Nonnegative
    private final int position;
    private List<T> lines;

    public Chunk(@Nonnegative int position, List<T> lines) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0);
        this.position = position;
        this.lines = lines;
    }

    public Chunk(@Nonnegative int position, T[] lines) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0);
        this.position = position;
        this.lines = Arrays.asList(lines);
    }

    public void verify(List<T> target) throws PatchFailedException {
        if (this.last() > target.size()) {
            throw new PatchFailedException("Incorrect Chunk: the position of chunk > target size");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (target.get(this.position + i).equals(this.lines.get(i))) continue;
            throw new PatchFailedException("Incorrect Chunk: the chunk content doesn't match the target");
        }
    }

    @Nonnegative
    public int getPosition() {
        return this.position;
    }

    public void setLines(List<T> lines) {
        this.lines = lines;
    }

    public List<T> getLines() {
        return this.lines;
    }

    @Nonnegative
    public int size() {
        return this.lines.size();
    }

    @Nonnegative
    public int last() {
        return this.getPosition() + this.size() - 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lines == null ? 0 : this.lines.hashCode());
        result = 31 * result + this.position;
        result = 31 * result + this.size();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Chunk other = (Chunk)obj;
        if (this.lines == null ? other.lines != null : !this.lines.equals(other.lines)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return "[position: " + this.position + ", size: " + this.size() + ", lines: " + this.lines + "]";
    }
}

