/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adsdisplayapi.v10.oauth2;

import jp.co.yahoo.adsdisplayapi.v10.oauth2.Cache;
import jp.co.yahoo.adsdisplayapi.v10.oauth2.OAuth2AccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2TokenService {
    private static final Logger log = LoggerFactory.getLogger(OAuth2TokenService.class);
    private static final String PROP_MAX_ATTEMPTS = "jp.co.yahoo.adsdisplayapi.oauth2.retry.max_attempts";
    private static final String PROP_INITIAL_INTERVAL = "jp.co.yahoo.adsdisplayapi.oauth2.retry.initial_interval";
    private static final String PROP_MULTIPLIER = "jp.co.yahoo.adsdisplayapi.oauth2.retry.multiplier";
    private static final String PROP_MAX_INTERVAL = "jp.co.yahoo.adsdisplayapi.oauth2.retry.max_interval";
    private static final String DEFAULT_MAX_ATTEMPTS = "3";
    private static final String DEFAULT_INITIAL_INTERVAL = "1000";
    private static final String DEFAULT_MULTIPLIER = "2";
    private static final String DEFAULT_MAX_INTERVAL = "2000";
    private final String clientId;
    private final String clientSecret;
    private final String refreshToken;
    private Cache cache = Cache.getInstance();
    private String oAuthTokenUrl = "https://biz-oauth.yahoo.co.jp/oauth/v1/token";
    private RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(Integer.parseInt(System.getProperty("jp.co.yahoo.adsdisplayapi.oauth2.retry.max_attempts", "3"))).exponentialBackoff((long)Integer.parseInt(System.getProperty("jp.co.yahoo.adsdisplayapi.oauth2.retry.initial_interval", "1000")), Double.parseDouble(System.getProperty("jp.co.yahoo.adsdisplayapi.oauth2.retry.multiplier", "2")), (long)Integer.parseInt(System.getProperty("jp.co.yahoo.adsdisplayapi.oauth2.retry.max_interval", "2000"))).build();
    private RestTemplate restTemplate = new RestTemplate();

    public OAuth2TokenService(String clientId, String clientSecret, String refreshToken) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.refreshToken = refreshToken;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public String getOAuthTokenUrl() {
        return this.oAuthTokenUrl;
    }

    public void setOAuthTokenUrl(String oAuthTokenUrl) {
        this.oAuthTokenUrl = oAuthTokenUrl;
    }

    public RetryTemplate getRetryTemplate() {
        return this.retryTemplate;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            log.debug("Try retrieve access token from cache.");
            OAuth2AccessTokenResponse oAuth2AccessTokenResponse = this.cache.get(this.refreshToken);
            if (oAuth2AccessTokenResponse == null || this.isExpired(oAuth2AccessTokenResponse)) {
                log.debug("Access token not found in cache or access token was expired. Refresh access token.");
                OAuth2AccessTokenResponse refreshedOAuth2AccessTokenResponse = this.refresh();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return refreshedOAuth2AccessTokenResponse.getAccessToken();
            }
            log.debug("Access token found in cache. Use cache data.");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return oAuth2AccessTokenResponse.getAccessToken();
        }
    }

    private boolean isExpired(OAuth2AccessTokenResponse oAuth2AccessTokenResponse) {
        long now;
        long bufferSec = 1800L;
        long expiresAt = oAuth2AccessTokenResponse.getIssuedAt() + (oAuth2AccessTokenResponse.getExpiresIn() - bufferSec);
        return expiresAt < (now = System.currentTimeMillis() / 1000L);
    }

    private OAuth2AccessTokenResponse refresh() {
        OAuth2AccessTokenResponse oAuth2AccessTokenResponse = this.getAccessTokenFromAPI();
        oAuth2AccessTokenResponse.setIssuedAt(System.currentTimeMillis() / 1000L);
        this.cache.put(this.refreshToken, oAuth2AccessTokenResponse);
        return oAuth2AccessTokenResponse;
    }

    private OAuth2AccessTokenResponse getAccessTokenFromAPI() {
        String url = UriComponentsBuilder.fromUriString((String)this.oAuthTokenUrl).queryParam("grant_type", new Object[]{"refresh_token"}).queryParam("client_id", new Object[]{this.clientId}).queryParam("client_secret", new Object[]{this.clientSecret}).queryParam("refresh_token", new Object[]{this.refreshToken}).toUriString();
        return (OAuth2AccessTokenResponse)this.retryTemplate.execute(retryContext -> (OAuth2AccessTokenResponse)this.restTemplate.getForObject(url, OAuth2AccessTokenResponse.class, new Object[0]));
    }
}

