/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adsdisplayapi.v5.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="<div lang=\"ja\">BudgetOrderServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u53d6\u5f97\u3059\u308b\u30a2\u30ab\u30a6\u30f3\u30c8\u4e88\u7b97\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002</div> <div lang=\"en\">The BudgetOrderServiceSelector object is used to select account budget for acquisition.</div> ")
public class BudgetOrderServiceSelector {
    private static final String EXTRA_INFO = "jp.co.yahoo.api-ads:ads-display-api-lib:0.0.12";
    @JsonProperty(value="accountIds")
    @Valid
    private List<Long> accountIds = new ArrayList<Long>();
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    @JsonProperty(value="_extraInfo")
    public String get_extraInfo() {
        return EXTRA_INFO;
    }

    public BudgetOrderServiceSelector accountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
        return this;
    }

    public BudgetOrderServiceSelector addAccountIdsItem(Long accountIdsItem) {
        if (this.accountIds == null) {
            this.accountIds = new ArrayList<Long>();
        }
        this.accountIds.add(accountIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Account ID.</div> ")
    @NotNull
    @Size(min=1, max=500)
    public @NotNull @Size(min=1, max=500) List<Long> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public BudgetOrderServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=500L)
    public @Min(value=1L) @Max(value=500L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public BudgetOrderServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BudgetOrderServiceSelector budgetOrderServiceSelector = (BudgetOrderServiceSelector)o;
        return Objects.equals(this.accountIds, budgetOrderServiceSelector.accountIds) && Objects.equals(this.numberResults, budgetOrderServiceSelector.numberResults) && Objects.equals(this.startIndex, budgetOrderServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(this.accountIds, this.numberResults, this.startIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BudgetOrderServiceSelector {\n");
        sb.append("    accountIds: ").append(this.toIndentedString(this.accountIds)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

