/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.concurrent.Semaphore;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.Rotation;

public class GPUImageView
extends FrameLayout {
    private GLSurfaceView mGLSurfaceView;
    private GPUImage mGPUImage;
    private GPUImageFilter mFilter;
    public Size mForceSize = null;
    private float mRatio = 0.0f;

    public GPUImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public GPUImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mGLSurfaceView = new GPUImageGLSurfaceView(context, attrs);
        this.addView((View)this.mGLSurfaceView);
        this.mGPUImage = new GPUImage(this.getContext());
        this.mGPUImage.setGLSurfaceView(this.mGLSurfaceView);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mRatio != 0.0f) {
            int newHeight;
            int newWidth;
            int height;
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            if ((float)width / this.mRatio < (float)(height = View.MeasureSpec.getSize((int)heightMeasureSpec))) {
                newWidth = width;
                newHeight = Math.round((float)width / this.mRatio);
            } else {
                newHeight = height;
                newWidth = Math.round((float)height * this.mRatio);
            }
            int newWidthSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
            int newHeightSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
            super.onMeasure(newWidthSpec, newHeightSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public GPUImage getGPUImage() {
        return this.mGPUImage;
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.mGPUImage.setBackgroundColor(red, green, blue);
    }

    public void setRatio(float ratio) {
        this.mRatio = ratio;
        this.mGLSurfaceView.requestLayout();
        this.mGPUImage.deleteImage();
    }

    public void setScaleType(GPUImage.ScaleType scaleType) {
        this.mGPUImage.setScaleType(scaleType);
    }

    public void setRotation(Rotation rotation) {
        this.mGPUImage.setRotation(rotation);
        this.requestRender();
    }

    public void setFilter(GPUImageFilter filter) {
        this.mFilter = filter;
        this.mGPUImage.setFilter(filter);
        this.requestRender();
    }

    public GPUImageFilter getFilter() {
        return this.mFilter;
    }

    public void setImage(Bitmap bitmap) {
        this.mGPUImage.setImage(bitmap);
    }

    public void setImage(Uri uri) {
        this.mGPUImage.setImage(uri);
    }

    public void setImage(File file) {
        this.mGPUImage.setImage(file);
    }

    public void requestRender() {
        this.mGLSurfaceView.requestRender();
    }

    public void saveToPictures(String folderName, String fileName, OnPictureSavedListener listener) {
        new SaveTask(folderName, fileName, listener).execute(new Void[0]);
    }

    public void saveToPictures(String folderName, String fileName, int width, int height, OnPictureSavedListener listener) {
        new SaveTask(folderName, fileName, width, height, listener).execute(new Void[0]);
    }

    public Bitmap capture(int width, int height) throws InterruptedException {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Do not call this method from the UI thread!");
        }
        this.mForceSize = new Size(width, height);
        final Semaphore waiter = new Semaphore(0);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    GPUImageView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    GPUImageView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                waiter.release();
            }
        });
        this.post(new Runnable(){

            @Override
            public void run() {
                GPUImageView.this.addView((View)new LoadingView(GPUImageView.this.getContext()));
                GPUImageView.this.mGLSurfaceView.requestLayout();
            }
        });
        waiter.acquire();
        this.mGPUImage.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                waiter.release();
            }
        });
        this.requestRender();
        waiter.acquire();
        Bitmap bitmap = this.capture();
        this.mForceSize = null;
        this.post(new Runnable(){

            @Override
            public void run() {
                GPUImageView.this.mGLSurfaceView.requestLayout();
            }
        });
        this.requestRender();
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                GPUImageView.this.removeViewAt(1);
            }
        }, 300L);
        return bitmap;
    }

    public Bitmap capture() throws InterruptedException {
        final Semaphore waiter = new Semaphore(0);
        final int width = this.mGLSurfaceView.getMeasuredWidth();
        final int height = this.mGLSurfaceView.getMeasuredHeight();
        final int[] pixelMirroredArray = new int[width * height];
        this.mGPUImage.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer pixelBuffer = IntBuffer.allocate(width * height);
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)pixelBuffer);
                int[] pixelArray = pixelBuffer.array();
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        pixelMirroredArray[(height - i - 1) * width + j] = pixelArray[i * width + j];
                    }
                }
                waiter.release();
            }
        });
        this.requestRender();
        waiter.acquire();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)IntBuffer.wrap(pixelMirroredArray));
        return bitmap;
    }

    public void onPause() {
        this.mGLSurfaceView.onPause();
    }

    public void onResume() {
        this.mGLSurfaceView.onResume();
    }

    public static interface OnPictureSavedListener {
        public void onPictureSaved(Uri var1);
    }

    private class SaveTask
    extends AsyncTask<Void, Void, Void> {
        private final String mFolderName;
        private final String mFileName;
        private final int mWidth;
        private final int mHeight;
        private final OnPictureSavedListener mListener;
        private final Handler mHandler;

        public SaveTask(String folderName, String fileName, OnPictureSavedListener listener) {
            this(folderName, fileName, 0, 0, listener);
        }

        public SaveTask(String folderName, String fileName, int width, int height, OnPictureSavedListener listener) {
            this.mFolderName = folderName;
            this.mFileName = fileName;
            this.mWidth = width;
            this.mHeight = height;
            this.mListener = listener;
            this.mHandler = new Handler();
        }

        protected Void doInBackground(Void ... params) {
            try {
                Bitmap result = this.mWidth != 0 ? GPUImageView.this.capture(this.mWidth, this.mHeight) : GPUImageView.this.capture();
                this.saveImage(this.mFolderName, this.mFileName, result);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }

        private void saveImage(String folderName, String fileName, Bitmap image) {
            File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            File file = new File(path, folderName + "/" + fileName);
            try {
                file.getParentFile().mkdirs();
                image.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)new FileOutputStream(file));
                MediaScannerConnection.scanFile((Context)GPUImageView.this.getContext(), (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, final Uri uri) {
                        if (SaveTask.this.mListener != null) {
                            SaveTask.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    SaveTask.this.mListener.onPictureSaved(uri);
                                }
                            });
                        }
                    }
                });
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private class LoadingView
    extends FrameLayout {
        public LoadingView(Context context) {
            super(context);
            this.init();
        }

        public LoadingView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.init();
        }

        public LoadingView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.init();
        }

        private void init() {
            ProgressBar view = new ProgressBar(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
            this.addView((View)view);
            this.setBackgroundColor(-16777216);
        }
    }

    private class GPUImageGLSurfaceView
    extends GLSurfaceView {
        public GPUImageGLSurfaceView(Context context) {
            super(context);
        }

        public GPUImageGLSurfaceView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (GPUImageView.this.mForceSize != null) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)GPUImageView.this.mForceSize.width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)GPUImageView.this.mForceSize.height, (int)0x40000000));
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }

    public static class Size {
        int width;
        int height;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

