/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class GPUImageLevelsFilter
extends GPUImageFilter {
    private static final String LOGTAG = GPUImageLevelsFilter.class.getSimpleName();
    public static final String LEVELS_FRAGMET_SHADER = " varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform mediump vec3 levelMinimum;\n uniform mediump vec3 levelMiddle;\n uniform mediump vec3 levelMaximum;\n uniform mediump vec3 minOutput;\n uniform mediump vec3 maxOutput;\n \n void main()\n {\n     mediump vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     \n     gl_FragColor = vec4( mix(minOutput, maxOutput, pow(min(max(textureColor.rgb -levelMinimum, vec3(0.0)) / (levelMaximum - levelMinimum  ), vec3(1.0)), 1.0 /levelMiddle)) , textureColor.a);\n }\n";
    private int mMinLocation;
    private float[] mMin;
    private int mMidLocation;
    private float[] mMid;
    private int mMaxLocation;
    private float[] mMax;
    private int mMinOutputLocation;
    private float[] mMinOutput;
    private int mMaxOutputLocation;
    private float[] mMaxOutput;

    public GPUImageLevelsFilter() {
        this(new float[]{0.0f, 0.0f, 0.0f}, new float[]{1.0f, 1.0f, 1.0f}, new float[]{1.0f, 1.0f, 1.0f}, new float[]{0.0f, 0.0f, 0.0f}, new float[]{1.0f, 1.0f, 1.0f});
    }

    private GPUImageLevelsFilter(float[] min, float[] mid, float[] max, float[] minOUt, float[] maxOut) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", LEVELS_FRAGMET_SHADER);
        this.mMin = min;
        this.mMid = mid;
        this.mMax = max;
        this.mMinOutput = minOUt;
        this.mMaxOutput = maxOut;
        this.setMin(0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mMinLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"levelMinimum");
        this.mMidLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"levelMiddle");
        this.mMaxLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"levelMaximum");
        this.mMinOutputLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"minOutput");
        this.mMaxOutputLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"maxOutput");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.updateUniforms();
    }

    public void updateUniforms() {
        this.setFloatVec3(this.mMinLocation, this.mMin);
        this.setFloatVec3(this.mMidLocation, this.mMid);
        this.setFloatVec3(this.mMaxLocation, this.mMax);
        this.setFloatVec3(this.mMinOutputLocation, this.mMinOutput);
        this.setFloatVec3(this.mMaxOutputLocation, this.mMaxOutput);
    }

    public void setMin(float min, float mid, float max, float minOut, float maxOut) {
        this.setRedMin(min, mid, max, minOut, maxOut);
        this.setGreenMin(min, mid, max, minOut, maxOut);
        this.setBlueMin(min, mid, max, minOut, maxOut);
    }

    public void setMin(float min, float mid, float max) {
        this.setMin(min, mid, max, 0.0f, 1.0f);
    }

    public void setRedMin(float min, float mid, float max, float minOut, float maxOut) {
        this.mMin[0] = min;
        this.mMid[0] = mid;
        this.mMax[0] = max;
        this.mMinOutput[0] = minOut;
        this.mMaxOutput[0] = maxOut;
        this.updateUniforms();
    }

    public void setRedMin(float min, float mid, float max) {
        this.setRedMin(min, mid, max, 0.0f, 1.0f);
    }

    public void setGreenMin(float min, float mid, float max, float minOut, float maxOut) {
        this.mMin[1] = min;
        this.mMid[1] = mid;
        this.mMax[1] = max;
        this.mMinOutput[1] = minOut;
        this.mMaxOutput[1] = maxOut;
        this.updateUniforms();
    }

    public void setGreenMin(float min, float mid, float max) {
        this.setGreenMin(min, mid, max, 0.0f, 1.0f);
    }

    public void setBlueMin(float min, float mid, float max, float minOut, float maxOut) {
        this.mMin[2] = min;
        this.mMid[2] = mid;
        this.mMax[2] = max;
        this.mMinOutput[2] = minOut;
        this.mMaxOutput[2] = maxOut;
        this.updateUniforms();
    }

    public void setBlueMin(float min, float mid, float max) {
        this.setBlueMin(min, mid, max, 0.0f, 1.0f);
    }
}

