/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class GPUImageRGBFilter
extends GPUImageFilter {
    public static final String RGB_FRAGMENT_SHADER = "  varying highp vec2 textureCoordinate;\n  \n  uniform sampler2D inputImageTexture;\n  uniform highp float red;\n  uniform highp float green;\n  uniform highp float blue;\n  \n  void main()\n  {\n      highp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n      \n      gl_FragColor = vec4(textureColor.r * red, textureColor.g * green, textureColor.b * blue, 1.0);\n  }\n";
    private int mRedLocation;
    private float mRed;
    private int mGreenLocation;
    private float mGreen;
    private int mBlueLocation;
    private float mBlue;
    private boolean mIsInitialized = false;

    public GPUImageRGBFilter() {
        this(1.0f, 1.0f, 1.0f);
    }

    public GPUImageRGBFilter(float red, float green, float blue) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", RGB_FRAGMENT_SHADER);
        this.mRed = red;
        this.mGreen = green;
        this.mBlue = blue;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mRedLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"red");
        this.mGreenLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"green");
        this.mBlueLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"blue");
        this.mIsInitialized = true;
        this.setRed(this.mRed);
        this.setGreen(this.mGreen);
        this.setBlue(this.mBlue);
    }

    public void setRed(float red) {
        this.mRed = red;
        if (this.mIsInitialized) {
            this.setFloat(this.mRedLocation, this.mRed);
        }
    }

    public void setGreen(float green) {
        this.mGreen = green;
        if (this.mIsInitialized) {
            this.setFloat(this.mGreenLocation, this.mGreen);
        }
    }

    public void setBlue(float blue) {
        this.mBlue = blue;
        if (this.mIsInitialized) {
            this.setFloat(this.mBlueLocation, this.mBlue);
        }
    }
}

