/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.graphics.Point;
import android.graphics.PointF;
import android.opengl.GLES20;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageToneCurveFilter
extends GPUImageFilter {
    public static final String TONE_CURVE_FRAGMENT_SHADER = " varying highp vec2 textureCoordinate;\n uniform sampler2D inputImageTexture;\n uniform sampler2D toneCurveTexture;\n\n void main()\n {\n     lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     lowp float redCurveValue = texture2D(toneCurveTexture, vec2(textureColor.r, 0.0)).r;\n     lowp float greenCurveValue = texture2D(toneCurveTexture, vec2(textureColor.g, 0.0)).g;\n     lowp float blueCurveValue = texture2D(toneCurveTexture, vec2(textureColor.b, 0.0)).b;\n\n     gl_FragColor = vec4(redCurveValue, greenCurveValue, blueCurveValue, textureColor.a);\n }";
    private int[] toneCurveTexture = new int[]{-1};
    private int toneCurveTextureUniformLocation;
    private PointF[] rgbCompositeControlPoints;
    private PointF[] redControlPoints;
    private PointF[] greenControlPoints;
    private PointF[] blueControlPoints;
    private ArrayList<Float> rgbCompositeCurve;
    private ArrayList<Float> redCurve;
    private ArrayList<Float> greenCurve;
    private ArrayList<Float> blueCurve;

    public GPUImageToneCurveFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", TONE_CURVE_FRAGMENT_SHADER);
        PointF[] defaultCurvePoints = new PointF[]{new PointF(0.0f, 0.0f), new PointF(0.5f, 0.5f), new PointF(1.0f, 1.0f)};
        this.rgbCompositeControlPoints = defaultCurvePoints;
        this.redControlPoints = defaultCurvePoints;
        this.greenControlPoints = defaultCurvePoints;
        this.blueControlPoints = defaultCurvePoints;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.toneCurveTextureUniformLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"toneCurveTexture");
        GLES20.glActiveTexture((int)33987);
        GLES20.glGenTextures((int)1, (int[])this.toneCurveTexture, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.toneCurveTexture[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setRgbCompositeControlPoints(this.rgbCompositeControlPoints);
        this.setRedControlPoints(this.redControlPoints);
        this.setGreenControlPoints(this.greenControlPoints);
        this.setBlueControlPoints(this.blueControlPoints);
    }

    @Override
    protected void onDrawArraysPre() {
        if (this.toneCurveTexture[0] != -1) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)this.toneCurveTexture[0]);
            GLES20.glUniform1i((int)this.toneCurveTextureUniformLocation, (int)3);
        }
    }

    public void setFromCurveFileInputStream(InputStream input) {
        try {
            short version = this.readShort(input);
            int totalCurves = this.readShort(input);
            ArrayList<PointF[]> curves = new ArrayList<PointF[]>(totalCurves);
            float pointRate = 0.003921569f;
            for (int i = 0; i < totalCurves; ++i) {
                int pointCount = this.readShort(input);
                PointF[] points = new PointF[pointCount];
                for (int j = 0; j < pointCount; ++j) {
                    short y = this.readShort(input);
                    short x = this.readShort(input);
                    points[j] = new PointF((float)x * pointRate, (float)y * pointRate);
                }
                curves.add(points);
            }
            input.close();
            this.rgbCompositeControlPoints = (PointF[])curves.get(0);
            this.redControlPoints = (PointF[])curves.get(1);
            this.greenControlPoints = (PointF[])curves.get(2);
            this.blueControlPoints = (PointF[])curves.get(3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private short readShort(InputStream input) throws IOException {
        return (short)(input.read() << 8 | input.read());
    }

    public void setRgbCompositeControlPoints(PointF[] points) {
        this.rgbCompositeControlPoints = points;
        this.rgbCompositeCurve = this.createSplineCurve(this.rgbCompositeControlPoints);
        this.updateToneCurveTexture();
    }

    public void setRedControlPoints(PointF[] points) {
        this.redControlPoints = points;
        this.redCurve = this.createSplineCurve(this.redControlPoints);
        this.updateToneCurveTexture();
    }

    public void setGreenControlPoints(PointF[] points) {
        this.greenControlPoints = points;
        this.greenCurve = this.createSplineCurve(this.greenControlPoints);
        this.updateToneCurveTexture();
    }

    public void setBlueControlPoints(PointF[] points) {
        this.blueControlPoints = points;
        this.blueCurve = this.createSplineCurve(this.blueControlPoints);
        this.updateToneCurveTexture();
    }

    private void updateToneCurveTexture() {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glActiveTexture((int)33987);
                GLES20.glBindTexture((int)3553, (int)GPUImageToneCurveFilter.this.toneCurveTexture[0]);
                if (GPUImageToneCurveFilter.this.redCurve.size() >= 256 && GPUImageToneCurveFilter.this.greenCurve.size() >= 256 && GPUImageToneCurveFilter.this.blueCurve.size() >= 256 && GPUImageToneCurveFilter.this.rgbCompositeCurve.size() >= 256) {
                    byte[] toneCurveByteArray = new byte[1024];
                    for (int currentCurveIndex = 0; currentCurveIndex < 256; ++currentCurveIndex) {
                        toneCurveByteArray[currentCurveIndex * 4 + 2] = (byte)((int)Math.min(Math.max((float)currentCurveIndex + ((Float)GPUImageToneCurveFilter.this.blueCurve.get(currentCurveIndex)).floatValue() + ((Float)GPUImageToneCurveFilter.this.rgbCompositeCurve.get(currentCurveIndex)).floatValue(), 0.0f), 255.0f) & 0xFF);
                        toneCurveByteArray[currentCurveIndex * 4 + 1] = (byte)((int)Math.min(Math.max((float)currentCurveIndex + ((Float)GPUImageToneCurveFilter.this.greenCurve.get(currentCurveIndex)).floatValue() + ((Float)GPUImageToneCurveFilter.this.rgbCompositeCurve.get(currentCurveIndex)).floatValue(), 0.0f), 255.0f) & 0xFF);
                        toneCurveByteArray[currentCurveIndex * 4] = (byte)((int)Math.min(Math.max((float)currentCurveIndex + ((Float)GPUImageToneCurveFilter.this.redCurve.get(currentCurveIndex)).floatValue() + ((Float)GPUImageToneCurveFilter.this.rgbCompositeCurve.get(currentCurveIndex)).floatValue(), 0.0f), 255.0f) & 0xFF);
                        toneCurveByteArray[currentCurveIndex * 4 + 3] = -1;
                    }
                    GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)256, (int)1, (int)0, (int)6408, (int)5121, (Buffer)ByteBuffer.wrap(toneCurveByteArray));
                }
            }
        });
    }

    private ArrayList<Float> createSplineCurve(PointF[] points) {
        if (points == null || points.length <= 0) {
            return null;
        }
        PointF[] pointsSorted = (PointF[])points.clone();
        Arrays.sort(pointsSorted, new Comparator<PointF>(){

            @Override
            public int compare(PointF point1, PointF point2) {
                if (point1.x < point2.x) {
                    return -1;
                }
                if (point1.x > point2.x) {
                    return 1;
                }
                return 0;
            }
        });
        Point[] convertedPoints = new Point[pointsSorted.length];
        for (int i = 0; i < points.length; ++i) {
            PointF point = pointsSorted[i];
            convertedPoints[i] = new Point((int)(point.x * 255.0f), (int)(point.y * 255.0f));
        }
        ArrayList<Point> splinePoints = this.createSplineCurve2(convertedPoints);
        Point firstSplinePoint = splinePoints.get(0);
        if (firstSplinePoint.x > 0) {
            for (int i = firstSplinePoint.x; i >= 0; --i) {
                splinePoints.add(0, new Point(i, 0));
            }
        }
        Point lastSplinePoint = splinePoints.get(splinePoints.size() - 1);
        if (lastSplinePoint.x < 255) {
            for (int i = lastSplinePoint.x + 1; i <= 255; ++i) {
                splinePoints.add(new Point(i, 255));
            }
        }
        ArrayList<Float> preparedSplinePoints = new ArrayList<Float>(splinePoints.size());
        for (Point newPoint : splinePoints) {
            Point origPoint = new Point(newPoint.x, newPoint.x);
            float distance = (float)Math.sqrt(Math.pow(origPoint.x - newPoint.x, 2.0) + Math.pow(origPoint.y - newPoint.y, 2.0));
            if (origPoint.y > newPoint.y) {
                distance = -distance;
            }
            preparedSplinePoints.add(Float.valueOf(distance));
        }
        return preparedSplinePoints;
    }

    private ArrayList<Point> createSplineCurve2(Point[] points) {
        ArrayList<Double> sdA = this.createSecondDerivative(points);
        int n = sdA.size();
        if (n < 1) {
            return null;
        }
        double[] sd = new double[n];
        for (int i = 0; i < n; ++i) {
            sd[i] = sdA.get(i);
        }
        ArrayList<Point> output = new ArrayList<Point>(n + 1);
        for (int i = 0; i < n - 1; ++i) {
            Point cur = points[i];
            Point next = points[i + 1];
            for (int x = cur.x; x < next.x; ++x) {
                double t = (double)(x - cur.x) / (double)(next.x - cur.x);
                double a = 1.0 - t;
                double b = t;
                double h = next.x - cur.x;
                double y = a * (double)cur.y + b * (double)next.y + h * h / 6.0 * ((a * a * a - a) * sd[i] + (b * b * b - b) * sd[i + 1]);
                if (y > 255.0) {
                    y = 255.0;
                } else if (y < 0.0) {
                    y = 0.0;
                }
                output.add(new Point(x, (int)Math.round(y)));
            }
        }
        if (output.size() == 255) {
            output.add(points[points.length - 1]);
        }
        return output;
    }

    private ArrayList<Double> createSecondDerivative(Point[] points) {
        int i;
        int n = points.length;
        if (n <= 1) {
            return null;
        }
        double[][] matrix = new double[n][3];
        double[] result = new double[n];
        matrix[0][1] = 1.0;
        matrix[0][0] = 0.0;
        matrix[0][2] = 0.0;
        for (i = 1; i < n - 1; ++i) {
            Point P1 = points[i - 1];
            Point P2 = points[i];
            Point P3 = points[i + 1];
            matrix[i][0] = (double)(P2.x - P1.x) / 6.0;
            matrix[i][1] = (double)(P3.x - P1.x) / 3.0;
            matrix[i][2] = (double)(P3.x - P2.x) / 6.0;
            result[i] = (double)(P3.y - P2.y) / (double)(P3.x - P2.x) - (double)(P2.y - P1.y) / (double)(P2.x - P1.x);
        }
        result[0] = 0.0;
        result[n - 1] = 0.0;
        matrix[n - 1][1] = 1.0;
        matrix[n - 1][0] = 0.0;
        matrix[n - 1][2] = 0.0;
        for (i = 1; i < n; ++i) {
            double k = matrix[i][0] / matrix[i - 1][1];
            double[] dArray = matrix[i];
            dArray[1] = dArray[1] - k * matrix[i - 1][2];
            matrix[i][0] = 0.0;
            int n2 = i;
            result[n2] = result[n2] - k * result[i - 1];
        }
        for (i = n - 2; i >= 0; --i) {
            double k = matrix[i][2] / matrix[i + 1][1];
            double[] dArray = matrix[i];
            dArray[1] = dArray[1] - k * matrix[i + 1][0];
            matrix[i][2] = 0.0;
            int n3 = i;
            result[n3] = result[n3] - k * result[i + 1];
        }
        ArrayList<Double> output = new ArrayList<Double>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            output.add(result[i2] / matrix[i2][1]);
        }
        return output;
    }
}

