/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageBulgeDistortionFilter
extends GPUImageFilter {
    public static final String BULGE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform highp float aspectRatio;\nuniform highp vec2 center;\nuniform highp float radius;\nuniform highp float scale;\n\nvoid main()\n{\nhighp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * aspectRatio + 0.5 - 0.5 * aspectRatio));\nhighp float dist = distance(center, textureCoordinateToUse);\ntextureCoordinateToUse = textureCoordinate;\n\nif (dist < radius)\n{\ntextureCoordinateToUse -= center;\nhighp float percent = 1.0 - ((radius - dist) / radius) * scale;\npercent = percent * percent;\n\ntextureCoordinateToUse = textureCoordinateToUse * percent;\ntextureCoordinateToUse += center;\n}\n\ngl_FragColor = texture2D(inputImageTexture, textureCoordinateToUse );    \n}\n";
    private float scale;
    private int scaleLocation;
    private float radius;
    private int radiusLocation;
    private PointF center;
    private int centerLocation;
    private float aspectRatio;
    private int aspectRatioLocation;

    public GPUImageBulgeDistortionFilter() {
        this(0.25f, 0.5f, new PointF(0.5f, 0.5f));
    }

    public GPUImageBulgeDistortionFilter(float radius, float scale, PointF center) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", BULGE_FRAGMENT_SHADER);
        this.radius = radius;
        this.scale = scale;
        this.center = center;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.scaleLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"scale");
        this.radiusLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"radius");
        this.centerLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"center");
        this.aspectRatioLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"aspectRatio");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setRadius(this.radius);
        this.setScale(this.scale);
        this.setCenter(this.center);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        this.aspectRatio = (float)height / (float)width;
        this.setAspectRatio(this.aspectRatio);
        super.onOutputSizeChanged(width, height);
    }

    private void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
        this.setFloat(this.aspectRatioLocation, aspectRatio);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.setFloat(this.radiusLocation, radius);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setFloat(this.scaleLocation, scale);
    }

    public void setCenter(PointF center) {
        this.center = center;
        this.setPoint(this.centerLocation, center);
    }
}

