/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.sqs.AbstractAmazonSQSTask;
import jp.classmethod.aws.gradle.sqs.AmazonSQSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class AmazonSQSMessageConsumerTask
extends AbstractAmazonSQSTask {
    private static final int MAX_MESSAGE_CONSUME_BATCH_SIZE = 10;
    private boolean showMessages = true;
    private boolean deleteMessages = true;
    private int maxNumberOfMessages = 1000;

    public AmazonSQSMessageConsumerTask() {
        this.setDescription("Consume/Delete SQS messages");
        this.setGroup("AWS");
    }

    @TaskAction
    public void consumeMessages() {
        ReceiveMessageRequest request;
        int counter;
        List<DeleteMessageBatchRequestEntry> messagesToDelete;
        String queueUrl = this.getQueueUrl();
        if (queueUrl == null) {
            throw new GradleException("Must specify either queueName or queueUrl");
        }
        AmazonSQSPluginExtension ext = (AmazonSQSPluginExtension)this.getProject().getExtensions().getByType(AmazonSQSPluginExtension.class);
        AmazonSQS sqs = (AmazonSQS)ext.getClient();
        for (counter = 0; counter < this.maxNumberOfMessages && !(messagesToDelete = sqs.receiveMessage(request = new ReceiveMessageRequest().withQueueUrl(queueUrl).withMaxNumberOfMessages(Integer.valueOf(10)).withVisibilityTimeout(Integer.valueOf(30))).getMessages().stream().map(message -> {
            if (this.showMessages) {
                this.getLogger().lifecycle(String.format(Locale.ENGLISH, "Read message id: %s, message body: %200s", message.getMessageId(), message.getBody()));
            }
            return new DeleteMessageBatchRequestEntry(message.getMessageId(), message.getReceiptHandle());
        }).collect(Collectors.toList())).isEmpty(); counter += messagesToDelete.size()) {
            this.deleteMessages(sqs, queueUrl, messagesToDelete);
        }
        this.getLogger().lifecycle("Consumed a total of {} messages from {}", new Object[]{counter, queueUrl});
    }

    private void deleteMessages(AmazonSQS sqs, String queueUrl, List<DeleteMessageBatchRequestEntry> messagesToDelete) {
        if (!this.deleteMessages || messagesToDelete.isEmpty()) {
            return;
        }
        this.getLogger().lifecycle("Deleting {} messages from {}, still working...", new Object[]{messagesToDelete.size(), queueUrl});
        sqs.deleteMessageBatch(queueUrl, messagesToDelete);
    }

    public void setShowMessages(boolean showMessages) {
        this.showMessages = showMessages;
    }

    public void setDeleteMessages(boolean deleteMessages) {
        this.deleteMessages = deleteMessages;
    }

    public void setMaxNumberOfMessages(int maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
    }
}

