/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class BucketWebsiteConfigurationTask
extends ConventionTask {
    private String bucketName;
    private String indexDoc;
    private String errorDoc;

    public BucketWebsiteConfigurationTask() {
        this.setDescription("Enable S3 bucket as public website");
        this.setGroup("AWS");
    }

    @TaskAction
    public void applyWebsiteConfiguration() {
        BucketWebsiteConfiguration websiteConfig = null;
        websiteConfig = this.getIndexDoc() == null ? new BucketWebsiteConfiguration() : (this.errorDoc == null ? new BucketWebsiteConfiguration(this.getIndexDoc()) : new BucketWebsiteConfiguration(this.getIndexDoc(), this.getErrorDoc()));
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        try {
            s3.setBucketWebsiteConfiguration(this.getBucketName(), websiteConfig);
        }
        catch (AmazonServiceException ex) {
            throw new GradleException("Failed to set website configuration for bucket " + this.getBucketName(), (Throwable)ex);
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getIndexDoc() {
        return this.indexDoc;
    }

    public void setIndexDoc(String indexDoc) {
        this.indexDoc = indexDoc;
    }

    public String getErrorDoc() {
        return this.errorDoc;
    }

    public void setErrorDoc(String errorDoc) {
        this.errorDoc = errorDoc;
    }
}

