/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import jp.classmethod.aws.gradle.s3.AbstractAmazonS3FileUploadTask;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class AmazonS3FileUploadTask
extends AbstractAmazonS3FileUploadTask {
    public AmazonS3FileUploadTask() {
        this.setDescription("Upload file to the Amazon S3 bucket.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void upload() throws IOException {
        String bucketName = this.getBucketName();
        String key = this.getKey();
        File file = this.getFile();
        String kmsKeyId = this.getKmsKeyId();
        if (bucketName == null) {
            throw new GradleException("bucketName is not specified");
        }
        if (key == null) {
            throw new GradleException("key is not specified");
        }
        if (file == null) {
            throw new GradleException("file is not specified");
        }
        if (!file.isFile()) {
            throw new GradleException("file must be regular file");
        }
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        ObjectMetadata metadata = this.existingObjectMetadata();
        if (metadata == null || this.isOverwrite() || !metadata.getETag().equals(this.md5())) {
            this.getLogger().info("uploading... " + bucketName + "/" + key);
            if (kmsKeyId == null) {
                this.putObject(bucketName, key, file, s3);
            } else {
                this.putObjectWithKmsSupport(bucketName, key, file, kmsKeyId, s3);
            }
            this.getLogger().info("upload completed: " + ((AmazonS3Client)s3).getResourceUrl(bucketName, key));
        } else {
            this.getLogger().info("s3://{}/{} already exists with matching md5 sum -- skipped", (Object)bucketName, (Object)key);
        }
        this.setResourceUrl(s3.getUrl(bucketName, key).toString());
    }

    private String md5() throws IOException {
        return Files.hash((File)this.getFile(), (HashFunction)Hashing.md5()).toString();
    }

    private void putObject(String bucketName, String key, File file, AmazonS3 s3) {
        s3.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(this.getObjectMetadata()));
    }

    private void putObjectWithKmsSupport(String bucketName, String key, File file, String kmsKeyId, AmazonS3 s3) {
        s3.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(this.getObjectMetadata()).withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(kmsKeyId)));
    }
}

