/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.model.AliasRoutingConfiguration;
import java.util.Collections;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class RoutingConfig {
    @Input
    private Double additionalVersionWeight;
    @Input
    @Optional
    private Boolean usePreviousVersion;
    @Input
    @Optional
    private Boolean useNextVersion;
    @Input
    @Optional
    private String additionalVersion;

    protected RoutingConfig() {
    }

    public AliasRoutingConfiguration getAliasRoutingConfiguration(String functionName, String functionVersion) {
        this.validateRequiredProperties();
        Double additionalVersionWeight = this.getAdditionalVersionWeight();
        AliasRoutingConfiguration aliasRoutingConfiguration = new AliasRoutingConfiguration();
        if (this.getAdditionalVersion() != null) {
            this.validateFunctionVersion(this.getAdditionalVersion());
            aliasRoutingConfiguration.withAdditionalVersionWeights(Collections.singletonMap(this.getAdditionalVersion(), additionalVersionWeight));
        } else if (this.getUsePreviousVersion() != null && this.getUsePreviousVersion().booleanValue()) {
            this.validateFunctionVersion(functionVersion);
            Long functionVersionAsLong = Long.valueOf(functionVersion);
            Long prevVersion = this.getPreviousVersion(functionName, functionVersionAsLong);
            aliasRoutingConfiguration.withAdditionalVersionWeights(Collections.singletonMap(prevVersion.toString(), additionalVersionWeight));
        } else if (this.getUseNextVersion() != null && this.getUseNextVersion().booleanValue()) {
            this.validateFunctionVersion(functionVersion);
            Long functionVersionAsLong = Long.valueOf(functionVersion);
            Long nextVersion = this.getNextVersion(functionVersionAsLong);
            aliasRoutingConfiguration.withAdditionalVersionWeights(Collections.singletonMap(nextVersion.toString(), additionalVersionWeight));
        }
        return aliasRoutingConfiguration;
    }

    private void validateFunctionVersion(String functionVersion) {
        if (!functionVersion.matches("[0-9]+")) {
            throw new GradleException("functionVersion must be a number if usePreviousVersion is true");
        }
    }

    private void validateRequiredProperties() throws GradleException {
        if (this.getAdditionalVersionWeight() == null) {
            throw new GradleException("Additional Version Weight for routing config is required");
        }
        if (this.getAdditionalVersion() == null && this.getUsePreviousVersion() == null && this.getUseNextVersion() == null) {
            throw new GradleException("Exactly one of AdditionalVersion, UsePreviousVersion, UseNextVersion for routing config is required");
        }
    }

    private Long getNextVersion(Long functionVersion) {
        return functionVersion + 1L;
    }

    private Long getPreviousVersion(String functionName, Long functionVersion) {
        if (functionVersion <= 1L) {
            throw new GradleException("There is no older version for " + functionName);
        }
        return functionVersion - 1L;
    }

    public Double getAdditionalVersionWeight() {
        return this.additionalVersionWeight;
    }

    public void setAdditionalVersionWeight(Double additionalVersionWeight) {
        this.additionalVersionWeight = additionalVersionWeight;
    }

    public Boolean getUsePreviousVersion() {
        return this.usePreviousVersion;
    }

    public void setUsePreviousVersion(Boolean usePreviousVersion) {
        this.usePreviousVersion = usePreviousVersion;
    }

    public Boolean getUseNextVersion() {
        return this.useNextVersion;
    }

    public void setUseNextVersion(Boolean useNextVersion) {
        this.useNextVersion = useNextVersion;
    }

    public String getAdditionalVersion() {
        return this.additionalVersion;
    }

    public void setAdditionalVersion(String additionalVersion) {
        this.additionalVersion = additionalVersion;
    }
}

