/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkTerminateEnvironmentTask
extends ConventionTask {
    private String appName;
    private String envName;
    private String envId;

    public AWSElasticBeanstalkTerminateEnvironmentTask() {
        this.setDescription("Terminate(Delete) ElasticBeanstalk Environment.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void terminateEnvironment() {
        String appName = this.getAppName();
        String envName = this.getEnvName();
        String envId = this.getEnvId();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        if (envId == null) {
            DescribeEnvironmentsResult der = eb.describeEnvironments(new DescribeEnvironmentsRequest().withApplicationName(appName).withEnvironmentNames(new String[]{envName}));
            if (der.getEnvironments() == null || der.getEnvironments().isEmpty()) {
                this.getLogger().warn("environment " + envName + " @ " + appName + " not found");
                return;
            }
            EnvironmentDescription ed = (EnvironmentDescription)der.getEnvironments().get(0);
            envId = ed.getEnvironmentId();
        }
        try {
            eb.terminateEnvironment(new TerminateEnvironmentRequest().withEnvironmentId(envId).withEnvironmentName(envName));
            this.getLogger().info("environment " + envName + " (" + envId + ") @ " + appName + " termination requested");
        }
        catch (AmazonServiceException e) {
            if (!e.getMessage().contains("No Environment found")) {
                throw e;
            }
            this.getLogger().warn("environment " + envName + " (" + envId + ") @ " + appName + " not found");
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getEnvId() {
        return this.envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }
}

