/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkDeleteApplicationTask
extends ConventionTask {
    private String appName;

    public AWSElasticBeanstalkDeleteApplicationTask() {
        this.setDescription("Delete ElasticBeanstalk Application.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteApplication() {
        String appName = this.getAppName();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        eb.deleteApplication(new DeleteApplicationRequest(appName));
        this.getLogger().info("application " + appName + " deleted");
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

