/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.Tag;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import jp.classmethod.aws.gradle.elasticbeanstalk.Tier;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkCreateEnvironmentTask
extends ConventionTask {
    private String appName;
    private String envName;
    private String envDesc = "";
    private String cnamePrefix = UUID.randomUUID().toString();
    private String templateName;
    private String versionLabel;
    private Tier tier = Tier.WebServer;
    private Map<String, String> tags = new HashMap<String, String>();

    public AWSElasticBeanstalkCreateEnvironmentTask() {
        this.setDescription("Create/Migrate ElasticBeanstalk Environment.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createEnvironment() {
        String appName = this.getAppName();
        String envName = this.getEnvName();
        String envDesc = this.getEnvDesc();
        String cnamePrefix = this.getCnamePrefix();
        String templateName = this.getTemplateName();
        String versionLabel = this.getVersionLabel();
        Tier tier = this.getTier();
        Map<String, String> tags = this.getTags();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        DescribeEnvironmentsResult der = eb.describeEnvironments(new DescribeEnvironmentsRequest().withApplicationName(appName).withEnvironmentNames(new String[]{envName}).withIncludeDeleted(Boolean.valueOf(false)));
        List ebTags = tags.entrySet().stream().map(entry -> {
            Tag t = new Tag();
            t.setKey((String)entry.getKey());
            t.setValue((String)entry.getValue());
            return t;
        }).collect(Collectors.toList());
        if (der.getEnvironments() == null || der.getEnvironments().isEmpty()) {
            CreateEnvironmentRequest req = new CreateEnvironmentRequest().withApplicationName(appName).withEnvironmentName(envName).withDescription(envDesc).withTemplateName(templateName).withVersionLabel(versionLabel);
            if (tier != null) {
                req.withTier(tier.toEnvironmentTier());
                if (tier == Tier.WebServer) {
                    req.withCNAMEPrefix(cnamePrefix);
                }
            }
            if (ebTags != null && !ebTags.isEmpty()) {
                req.withTags(ebTags);
            }
            CreateEnvironmentResult result = eb.createEnvironment(req);
            this.getLogger().info("environment {} @ {} ({}) created", new Object[]{envName, appName, result.getEnvironmentId()});
        } else {
            String environmentId = ((EnvironmentDescription)der.getEnvironments().get(0)).getEnvironmentId();
            UpdateEnvironmentRequest req = new UpdateEnvironmentRequest().withEnvironmentId(environmentId).withVersionLabel(versionLabel);
            if (this.isNotBlank(envName)) {
                req.withEnvironmentName(envName);
            }
            if (this.isNotBlank(envDesc)) {
                req.withDescription(envDesc);
            }
            if (this.isNotBlank(templateName)) {
                req.withTemplateName(templateName);
            }
            eb.updateEnvironment(req);
            this.getLogger().info("environment {} @ {} ({}) updated", new Object[]{envName, appName, environmentId});
        }
    }

    private boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getEnvDesc() {
        return this.envDesc;
    }

    public void setEnvDesc(String envDesc) {
        this.envDesc = envDesc;
    }

    public String getCnamePrefix() {
        return this.cnamePrefix;
    }

    public void setCnamePrefix(String cnamePrefix) {
        this.cnamePrefix = cnamePrefix;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setTier(Tier tier) {
        this.tier = tier;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}

