/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import java.util.Arrays;
import java.util.List;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2WaitInstanceStatusTask
extends ConventionTask {
    private String instanceId;
    private List<String> successStatuses = Arrays.asList("running", "stopped", "terminated");
    private List<String> waitStatuses = Arrays.asList("pending", "shutting-down", "stopping");
    private int loopTimeout = 900;
    private int loopWait = 10;
    private boolean found;
    private String lastStatus;
    private Instance awsInstance;

    public AmazonEC2WaitInstanceStatusTask() {
        this.setDescription("Wait EC2 instance for specific status.");
        this.setGroup("AWS");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void waitInstanceForStatus() {
        String instanceId = this.getInstanceId();
        List<String> successStatuses = this.getSuccessStatuses();
        List<String> waitStatuses = this.getWaitStatuses();
        int loopTimeout = this.getLoopTimeout();
        int loopWait = this.getLoopWait();
        if (instanceId == null) {
            throw new GradleException("instanceId is not specified");
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        long start = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() > start + (long)(loopTimeout * 1000)) {
                throw new GradleException("Timeout");
            }
            try {
                Instance instance;
                DescribeInstancesResult dir = ec2.describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId}));
                this.awsInstance = instance = (Instance)((Reservation)dir.getReservations().get(0)).getInstances().get(0);
                if (instance == null) {
                    throw new GradleException(instanceId + " is not exists");
                }
                this.found = true;
                this.lastStatus = instance.getState().getName();
                if (successStatuses.contains(this.lastStatus)) {
                    this.getLogger().info("Status of instance {} is now {}.", (Object)instanceId, (Object)this.lastStatus);
                    return;
                }
                if (!waitStatuses.contains(this.lastStatus)) throw new GradleException("Status of " + instanceId + " is " + this.lastStatus + ".  It seems to be failed.");
                this.getLogger().info("Status of instance {} is {}...", (Object)instanceId, (Object)this.lastStatus);
                try {
                    Thread.sleep(loopWait * 1000);
                }
                catch (InterruptedException e) {
                    throw new GradleException("Sleep interrupted", (Throwable)e);
                }
            }
            catch (AmazonServiceException e) {
                if (!this.found) throw new GradleException("Fail to describe instance: " + instanceId, (Throwable)e);
                return;
            }
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public List<String> getSuccessStatuses() {
        return this.successStatuses;
    }

    public void setSuccessStatuses(List<String> successStatuses) {
        this.successStatuses = successStatuses;
    }

    public List<String> getWaitStatuses() {
        return this.waitStatuses;
    }

    public void setWaitStatuses(List<String> waitStatuses) {
        this.waitStatuses = waitStatuses;
    }

    public int getLoopTimeout() {
        return this.loopTimeout;
    }

    public void setLoopTimeout(int loopTimeout) {
        this.loopTimeout = loopTimeout;
    }

    public int getLoopWait() {
        return this.loopWait;
    }

    public void setLoopWait(int loopWait) {
        this.loopWait = loopWait;
    }

    public boolean isFound() {
        return this.found;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public Instance getAwsInstance() {
        return this.awsInstance;
    }
}

