/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2RunInstanceTask
extends ConventionTask {
    private String ami;
    private String keyName;
    private List<String> securityGroupIds;
    private List<String> securityGroups;
    private String userData;
    private String instanceType;
    private String subnetId;
    private String iamInstanceProfileName;
    private RunInstancesResult runInstancesResult;

    public AmazonEC2RunInstanceTask() {
        this.setDescription("Run EC2 instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void runInstance() {
        String ami = this.getAmi();
        String keyName = this.getKeyName();
        List<String> securityGroupIds = this.getSecurityGroupIds();
        String userData = this.getUserData();
        String instanceType = this.getInstanceType();
        String subnetId = this.getSubnetId();
        String iamInstanceProfileName = this.getIamInstanceProfileName();
        List<String> securityGroups = this.getSecurityGroups();
        if (ami == null) {
            throw new GradleException("AMI ID is required");
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        RunInstancesRequest request = new RunInstancesRequest().withImageId(ami).withKeyName(keyName).withMinCount(Integer.valueOf(1)).withMaxCount(Integer.valueOf(1)).withSecurityGroupIds(securityGroupIds).withSecurityGroups(securityGroups).withInstanceType(instanceType).withSubnetId(subnetId).withIamInstanceProfile(new IamInstanceProfileSpecification().withName(iamInstanceProfileName));
        if (!Strings.isNullOrEmpty((String)this.userData)) {
            request.setUserData(new String(Base64.getEncoder().encode(userData.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        }
        this.runInstancesResult = ec2.runInstances(request);
        String instanceIds = this.runInstancesResult.getReservation().getInstances().stream().map(i -> i.getInstanceId()).collect(Collectors.joining(", "));
        this.getLogger().info("Run EC2 instance requested: {}", (Object)instanceIds);
    }

    public String getAmi() {
        return this.ami;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(List<String> securityGroupIds) {
        this.securityGroupIds = securityGroupIds;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getIamInstanceProfileName() {
        return this.iamInstanceProfileName;
    }

    public void setIamInstanceProfileName(String iamInstanceProfileName) {
        this.iamInstanceProfileName = iamInstanceProfileName;
    }

    public RunInstancesResult getRunInstancesResult() {
        return this.runInstancesResult;
    }
}

