/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.AmazonCloudFormationException;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackResource;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.common.BaseRegionAwarePluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonCloudFormationPluginExtension
extends BaseRegionAwarePluginExtension<AmazonCloudFormationClient> {
    private static Logger logger = LoggerFactory.getLogger(AmazonCloudFormationPluginExtension.class);
    public static final String NAME = "cloudFormation";
    private String stackName;
    private Map<?, ?> stackParams = new HashMap();
    private Map<?, ?> stackTags = new HashMap();
    private String cfnRoleArn;
    private String templateURL;
    private String onFailure;
    private File templateFile;
    private String templateBucket;
    private String templateKeyPrefix;
    private String stackPolicyURL;
    private File stackPolicyFile;
    private String stackPolicyBucket;
    private String stackPolicyKeyPrefix;
    private boolean capabilityIam;
    private Capability useCapabilityIam;
    private boolean terminationProtected;

    public AmazonCloudFormationPluginExtension(Project project) {
        super(project, AmazonCloudFormationClient.class);
    }

    public Optional<Stack> getStack() {
        return this.getStack(this.stackName);
    }

    public Optional<Stack> getStack(String stackName) {
        if (!this.getProject().getGradle().getStartParameter().isOffline()) {
            try {
                DescribeStacksResult describeStacksResult = ((AmazonCloudFormationClient)this.getClient()).describeStacks(new DescribeStacksRequest().withStackName(stackName));
                List stacks = describeStacksResult.getStacks();
                if (!stacks.isEmpty()) {
                    return stacks.stream().findAny();
                }
            }
            catch (AmazonCloudFormationException e) {
                if ("ValidationError".equals(e.getErrorCode())) {
                    return Optional.empty();
                }
                throw new GradleException(e.getMessage(), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public List<Parameter> getStackParameters() {
        return this.getStackParameters(this.stackName);
    }

    public List<Parameter> getStackParameters(String stackName) {
        if (!this.getProject().getGradle().getStartParameter().isOffline()) {
            Optional<Stack> stack = this.getStack(stackName);
            return stack.map(Stack::getParameters).orElse(Collections.emptyList());
        }
        logger.info("offline mode: return empty parameters");
        return Collections.emptyList();
    }

    public List<Output> getStackOutputs() {
        return this.getStackOutputs(this.stackName);
    }

    public List<Output> getStackOutputs(String stackName) {
        if (!this.getProject().getGradle().getStartParameter().isOffline()) {
            Optional<Stack> stack = this.getStack(stackName);
            return stack.map(Stack::getOutputs).orElse(Collections.emptyList());
        }
        logger.info("offline mode: return empty outputs");
        return Collections.emptyList();
    }

    public List<StackResource> getStackResources() {
        return this.getStackResources(this.stackName);
    }

    public List<StackResource> getStackResources(String stackName) {
        if (!this.getProject().getGradle().getStartParameter().isOffline()) {
            try {
                DescribeStackResourcesResult describeStackResourcesResult = ((AmazonCloudFormationClient)this.getClient()).describeStackResources(new DescribeStackResourcesRequest().withStackName(stackName));
                return describeStackResourcesResult.getStackResources();
            }
            catch (AmazonCloudFormationException e) {
                if ("ValidationError".equals(e.getErrorCode())) {
                    return Collections.emptyList();
                }
                throw new GradleException(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("offline mode: return empty resources");
        return Collections.emptyList();
    }

    public String getStackParameterValue(String key) {
        return this.getStackParameterValue(this.stackName, key);
    }

    public String getStackParameterValue(String stackName, String key) {
        return this.findStackParameterValue(stackName, key);
    }

    public String findStackParameterValue(String stackName, String key) {
        Optional<Parameter> param = this.getStackParameters(stackName).stream().filter(p -> p.getParameterKey().equals(key)).findAny();
        if (!param.isPresent()) {
            logger.warn("WARN: param {} for stack {} is not found", (Object)key, (Object)stackName);
        }
        return param.map(Parameter::getParameterValue).orElse(null);
    }

    public String getStackOutputValue(String key) {
        return this.getStackOutputValue(this.stackName, key);
    }

    public String getStackOutputValue(String stackName, String key) {
        return this.findStackOutputValue(stackName, key);
    }

    public String findStackOutputValue(String stackName, String key) {
        Optional<Output> output = this.getStackOutputs(stackName).stream().filter(p -> p.getOutputKey().equals(key)).findAny();
        if (!output.isPresent()) {
            logger.warn("WARN: output {} for stack {} is not found", (Object)key, (Object)stackName);
        }
        return output.map(Output::getOutputValue).orElse(null);
    }

    public String getPhysicalResourceId(String logicalResourceId) {
        return this.getPhysicalResourceId(this.stackName, logicalResourceId);
    }

    public String getPhysicalResourceId(String stackName, String logicalResourceId) {
        return this.findPhysicalResourceId(stackName, logicalResourceId);
    }

    public String findPhysicalResourceId(String stackName, String logicalResourceId) {
        Optional<StackResource> physicalResource = this.getStackResources(stackName).stream().filter(r -> r.getLogicalResourceId().equals(logicalResourceId)).findAny();
        if (!physicalResource.isPresent()) {
            logger.warn("WARN: physical resource {} for stack {} is not found", (Object)logicalResourceId, (Object)stackName);
        }
        return physicalResource.map(StackResource::getPhysicalResourceId).orElse(null);
    }

    public boolean isValidTemplateBody(String templateBody) {
        try {
            ValidateTemplateRequest validateTemplateRequest = new ValidateTemplateRequest().withTemplateBody(templateBody);
            ((AmazonCloudFormationClient)this.getClient()).validateTemplate(validateTemplateRequest);
            return true;
        }
        catch (AmazonClientException e) {
            logger.error("validateTemplateBody failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean isValidTemplateUrl(String templateUrl) {
        try {
            ValidateTemplateRequest validateTemplateRequest = new ValidateTemplateRequest().withTemplateURL(templateUrl);
            ((AmazonCloudFormationClient)this.getClient()).validateTemplate(validateTemplateRequest);
            return true;
        }
        catch (AmazonClientException e) {
            logger.error("validateTemplateUrl failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    public List<Parameter> toParameters(Map<String, String> map) {
        return map.entrySet().stream().map(e -> new Parameter().withParameterKey((String)e.getKey()).withParameterValue((String)e.getValue())).collect(Collectors.toList());
    }

    public Map<String, String> toMap(List<Parameter> parameters) {
        return parameters.stream().collect(Collectors.toMap(Parameter::getParameterKey, Parameter::getParameterValue));
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public Map<?, ?> getStackParams() {
        return this.stackParams;
    }

    public void setStackParams(Map<?, ?> stackParams) {
        this.stackParams = stackParams;
    }

    public Map<?, ?> getStackTags() {
        return this.stackTags;
    }

    public void setStackTags(Map<?, ?> stackTags) {
        this.stackTags = stackTags;
    }

    public String getCfnRoleArn() {
        return this.cfnRoleArn;
    }

    public void setCfnRoleArn(String cfnRoleArn) {
        this.cfnRoleArn = cfnRoleArn;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    public String getOnFailure() {
        return this.onFailure;
    }

    public void setOnFailure(String onFailure) {
        this.onFailure = onFailure;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public String getTemplateBucket() {
        return this.templateBucket;
    }

    public void setTemplateBucket(String templateBucket) {
        this.templateBucket = templateBucket;
    }

    public String getTemplateKeyPrefix() {
        return this.templateKeyPrefix;
    }

    public void setTemplateKeyPrefix(String templateKeyPrefix) {
        this.templateKeyPrefix = templateKeyPrefix;
    }

    public String getStackPolicyURL() {
        return this.stackPolicyURL;
    }

    public void setStackPolicyURL(String stackPolicyURL) {
        this.stackPolicyURL = stackPolicyURL;
    }

    public File getStackPolicyFile() {
        return this.stackPolicyFile;
    }

    public void setStackPolicyFile(File stackPolicyFile) {
        this.stackPolicyFile = stackPolicyFile;
    }

    public String getStackPolicyBucket() {
        return this.stackPolicyBucket;
    }

    public void setStackPolicyBucket(String stackPolicyBucket) {
        this.stackPolicyBucket = stackPolicyBucket;
    }

    public String getStackPolicyKeyPrefix() {
        return this.stackPolicyKeyPrefix;
    }

    public void setStackPolicyKeyPrefix(String stackPolicyKeyPrefix) {
        this.stackPolicyKeyPrefix = stackPolicyKeyPrefix;
    }

    public boolean isCapabilityIam() {
        return this.capabilityIam;
    }

    public void setCapabilityIam(boolean capabilityIam) {
        this.capabilityIam = capabilityIam;
    }

    public Capability getUseCapabilityIam() {
        return this.useCapabilityIam;
    }

    public void setUseCapabilityIam(Capability useCapabilityIam) {
        this.useCapabilityIam = useCapabilityIam;
    }

    public boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setTerminationProtected(boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }
}

