/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class AwsPluginExtension {
    public static final String NAME = "aws";
    private final Project project;
    private String profileName;
    private String region = Regions.US_EAST_1.getName();
    private String proxyHost;
    private int proxyPort = -1;
    private AWSCredentialsProvider credentialsProvider;

    public AWSCredentialsProvider newCredentialsProvider(String profileName) {
        String profileNameToUse;
        if (this.credentialsProvider != null) {
            return this.credentialsProvider;
        }
        String string = profileNameToUse = profileName != null ? profileName : this.profileName;
        if (!Strings.isNullOrEmpty((String)profileNameToUse)) {
            ArrayList<Object> providers = new ArrayList<Object>();
            providers.add(new EnvironmentVariableCredentialsProvider());
            providers.add(new SystemPropertiesCredentialsProvider());
            providers.add(new ProfileCredentialsProvider(profileNameToUse));
            providers.add(new EC2ContainerCredentialsProviderWrapper());
            return new AWSCredentialsProviderChain(providers);
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }

    public <T extends AmazonWebServiceClient> T createClient(Class<T> serviceClass, String profileName) {
        return this.createClient(serviceClass, profileName, null);
    }

    public <T extends AmazonWebServiceClient> T createClient(Class<T> serviceClass, String profileName, ClientConfiguration config) {
        ClientConfiguration configToUse;
        AWSCredentialsProvider credentialsProvider = this.newCredentialsProvider(profileName);
        ClientConfiguration clientConfiguration = configToUse = config == null ? new ClientConfiguration() : config;
        if (this.proxyHost != null && this.proxyPort > 0) {
            configToUse.setProxyHost(this.proxyHost);
            configToUse.setProxyPort(this.proxyPort);
        }
        return AwsPluginExtension.createClient(serviceClass, credentialsProvider, configToUse);
    }

    private static <T extends AmazonWebServiceClient> T createClient(Class<T> serviceClass, AWSCredentialsProvider credentials, ClientConfiguration config) {
        try {
            AmazonWebServiceClient client;
            if (credentials == null && config == null) {
                Constructor<T> constructor = serviceClass.getConstructor(new Class[0]);
                client = (AmazonWebServiceClient)constructor.newInstance(new Object[0]);
            } else if (credentials == null) {
                Constructor<T> constructor = serviceClass.getConstructor(ClientConfiguration.class);
                client = (AmazonWebServiceClient)constructor.newInstance(config);
            } else if (config == null) {
                Constructor<T> constructor = serviceClass.getConstructor(AWSCredentialsProvider.class);
                client = (AmazonWebServiceClient)constructor.newInstance(credentials);
            } else {
                Constructor<T> constructor = serviceClass.getConstructor(AWSCredentialsProvider.class, ClientConfiguration.class);
                client = (AmazonWebServiceClient)constructor.newInstance(credentials, config);
            }
            return (T)client;
        }
        catch (ReflectiveOperationException e) {
            throw new GradleException("Couldn't instantiate instance of " + serviceClass, (Throwable)e);
        }
    }

    public Region getActiveRegion(String clientRegion) {
        if (clientRegion != null) {
            return RegionUtils.getRegion((String)clientRegion);
        }
        if (this.region == null) {
            throw new IllegalStateException("default region is null");
        }
        return RegionUtils.getRegion((String)this.region);
    }

    public String getActiveProfileName(String clientProfileName) {
        if (clientProfileName != null) {
            return clientProfileName;
        }
        if (this.profileName == null) {
            throw new IllegalStateException("default profileName is null");
        }
        return this.profileName;
    }

    public String getAccountId() {
        try {
            AWSSecurityTokenService sts = (AWSSecurityTokenService)this.createClient(AWSSecurityTokenServiceClient.class, this.profileName);
            sts.setRegion(this.getActiveRegion(this.region));
            return sts.getCallerIdentity(new GetCallerIdentityRequest()).getAccount();
        }
        catch (SdkClientException e) {
            this.project.getLogger().lifecycle("AWS credentials not configured!");
            return null;
        }
    }

    public String getUserArn() {
        try {
            AWSSecurityTokenService sts = (AWSSecurityTokenService)this.createClient(AWSSecurityTokenServiceClient.class, this.profileName);
            sts.setRegion(this.getActiveRegion(this.region));
            return sts.getCallerIdentity(new GetCallerIdentityRequest()).getArn();
        }
        catch (SdkClientException e) {
            this.project.getLogger().lifecycle("AWS credentials not configured!");
            return null;
        }
    }

    @ConstructorProperties(value={"project"})
    public AwsPluginExtension(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }
}

