/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.adapter.DocumentAdapter;
import com.jgoodies.binding.adapter.RadioButtonAdapter;
import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public final class Bindings {
    private static final FocusLostHandler FOCUS_LOST_HANDLER = new FocusLostHandler();
    private static final Trigger FOCUS_LOST_TRIGGER = new Trigger();

    private Bindings() {
    }

    public static void bind(JCheckBox checkBox, ValueModel valueModel) {
        boolean enabled = checkBox.getModel().isEnabled();
        checkBox.setModel(new ToggleButtonAdapter(valueModel));
        checkBox.setEnabled(enabled);
    }

    public static void bind(JCheckBoxMenuItem checkBoxMenuItem, ValueModel valueModel) {
        boolean enabled = checkBoxMenuItem.getModel().isEnabled();
        checkBoxMenuItem.setModel(new ToggleButtonAdapter(valueModel));
        checkBoxMenuItem.setEnabled(enabled);
    }

    public static void bind(JFormattedTextField textField, ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        PropertyConnector connector = new PropertyConnector(valueModel, "value", textField, "value");
        connector.updateProperty2();
    }

    public static void bind(JLabel label, ValueModel valueModel) {
        PropertyConnector connector = new PropertyConnector(valueModel, "value", label, "text");
        connector.updateProperty2();
    }

    public static void bind(JList list, SelectionInList selectionInList) {
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        list.setModel(selectionInList);
        list.setSelectionModel(new SingleListSelectionAdapter(selectionInList.getSelectionIndexHolder()));
    }

    public static void bind(JRadioButton radioButton, ValueModel model, Object choice) {
        boolean enabled = radioButton.getModel().isEnabled();
        radioButton.setModel(new RadioButtonAdapter(model, choice));
        radioButton.setEnabled(enabled);
    }

    public static void bind(JRadioButtonMenuItem radioButtonMenuItem, ValueModel model, Object choice) {
        boolean enabled = radioButtonMenuItem.getModel().isEnabled();
        radioButtonMenuItem.setModel(new RadioButtonAdapter(model, choice));
        radioButtonMenuItem.setEnabled(enabled);
    }

    public static void bind(JTextComponent textComponent, ValueModel valueModel) {
        Bindings.bind(textComponent, valueModel, false);
    }

    public static void bind(JTextComponent textComponent, ValueModel valueModel, boolean commitOnFocusLost) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        ValueModel textModel = commitOnFocusLost ? Bindings.createCommitOnFocusLostModel(valueModel, textComponent) : valueModel;
        textComponent.setDocument(new DocumentAdapter(textModel, textComponent instanceof JTextField));
    }

    private static ValueModel createCommitOnFocusLostModel(ValueModel valueModel, Component component) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        BufferedValueModel model = new BufferedValueModel(valueModel, FOCUS_LOST_TRIGGER);
        component.addFocusListener(FOCUS_LOST_HANDLER);
        return model;
    }

    private static class FocusLostHandler
    extends FocusAdapter {
        private FocusLostHandler() {
        }

        public void focusLost(FocusEvent evt) {
            if (!evt.isTemporary()) {
                FOCUS_LOST_TRIGGER.triggerCommit();
            }
        }
    }
}

