/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.example;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;

public class ManyContexts {
    public static void main(String[] args) throws Exception {
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(8080);
        server.setConnectors(new Connector[]{connector});
        ContextHandler context0 = new ContextHandler();
        context0.setContextPath("/zero");
        HelloHandler handler0 = new HelloHandler();
        context0.setHandler((Handler)handler0);
        ContextHandler context1 = new ContextHandler();
        context1.setContextPath("/one");
        HelloHandler handler1 = new HelloHandler();
        context1.setHandler((Handler)handler1);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{context0, context1});
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{contexts, new DefaultHandler()});
        server.setHandler((Handler)handlers);
        server.start();
        server.join();
    }

    public static class HelloHandler
    extends AbstractHandler {
        static int h = 0;
        int hello = h++;

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            response.setStatus(200);
            response.setContentType("text/html");
            response.getWriter().println("<h1>Hello OneContext " + this.hello + "</h1>");
        }
    }
}

