/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigImplMBean;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.Null;
import org.jboss.util.Primitives;
import org.jboss.util.platform.Java;

public class ServerConfigImpl
implements ServerConfig,
ServerConfigImplMBean {
    private Properties props;
    private File homeDir;
    private URL homeURL;
    private URL libraryURL;
    private Object patchURL;
    private String serverSpecificationVersion;
    private String serverName;
    private File serverBaseDir;
    private File serverHomeDir;
    private File serverLogDir;
    private File serverTempDir;
    private File serverDataDir;
    private URL serverBaseURL;
    private URL serverHomeURL;
    private URL serverLibraryURL;
    private URL serverConfigURL;
    private Boolean exitOnShutdown;
    private Boolean blockingShutdown;
    private Boolean requireJBossURLStreamHandlerFactory;
    private Boolean platformMBeanServer;
    private String rootDeployableFilename;

    public ServerConfigImpl(Properties props) throws Exception {
        this.props = props;
        this.homeDir = this.getFile("jboss.home.dir");
        if (this.homeDir == null) {
            throw new Exception("Missing configuration value for: jboss.home.dir");
        }
        System.setProperty("jboss.home.dir", this.homeDir.toString());
        this.getServerHomeDir();
        Package thisPackage = this.getClass().getPackage();
        this.serverSpecificationVersion = thisPackage.getSpecificationVersion();
    }

    public void initURLs() throws MalformedURLException {
        this.homeURL = this.getURL("jboss.home.url");
        if (this.homeURL == null) {
            this.homeURL = this.homeDir.toURL();
        }
        System.setProperty("jboss.home.url", this.homeURL.toString());
    }

    public String getSpecificationVersion() {
        return this.serverSpecificationVersion;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public URL getHomeURL() {
        return this.homeURL;
    }

    public URL getLibraryURL() {
        if (this.libraryURL == null) {
            try {
                this.libraryURL = this.getURL("jboss.lib.url");
                if (this.libraryURL == null) {
                    this.libraryURL = new URL(this.homeURL, "lib/");
                }
                System.setProperty("jboss.lib.url", this.libraryURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.libraryURL;
    }

    public URL getPatchURL() {
        if (this.patchURL == null) {
            try {
                this.patchURL = this.getURL("jboss.patch.url");
                if (this.patchURL == null) {
                    this.patchURL = Null.VALUE;
                } else {
                    System.setProperty("jboss.patch.url", this.patchURL.toString());
                }
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        if (this.patchURL == Null.VALUE) {
            return null;
        }
        return (URL)this.patchURL;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.props.getProperty("jboss.server.name", "production");
            System.setProperty("jboss.server.name", this.serverName);
        }
        return this.serverName;
    }

    public File getServerBaseDir() {
        if (this.serverBaseDir == null) {
            this.serverBaseDir = this.getFile("jboss.server.base.dir");
            if (this.serverBaseDir == null) {
                this.serverBaseDir = new File(this.homeDir, "server");
                System.setProperty("jboss.server.base.dir", this.serverBaseDir.toString());
            }
        }
        return this.serverBaseDir;
    }

    public File getServerHomeDir() {
        if (this.serverHomeDir == null) {
            this.serverHomeDir = this.getFile("jboss.server.home.dir");
            if (this.serverHomeDir == null) {
                this.serverHomeDir = new File(this.getServerBaseDir(), this.getServerName());
                System.setProperty("jboss.server.home.dir", this.serverHomeDir.toString());
            }
        }
        return this.serverHomeDir;
    }

    public File getServerLogDir() {
        if (this.serverLogDir == null) {
            this.serverLogDir = this.getFile("jboss.server.log.dir");
            if (this.serverLogDir == null) {
                this.serverLogDir = new File(this.getServerHomeDir(), "log");
                System.setProperty("jboss.server.log.dir", this.serverLogDir.toString());
            }
        }
        return this.serverLogDir;
    }

    public File getServerTempDir() {
        if (this.serverTempDir == null) {
            this.serverTempDir = this.getFile("jboss.server.temp.dir");
            if (this.serverTempDir == null) {
                this.serverTempDir = new File(this.getServerHomeDir(), "tmp");
                System.setProperty("jboss.server.temp.dir", this.serverTempDir.toString());
            }
        }
        return this.serverTempDir;
    }

    public File getServerDataDir() {
        if (this.serverDataDir == null) {
            this.serverDataDir = this.getFile("jboss.server.data.dir");
            if (this.serverDataDir == null) {
                this.serverDataDir = new File(this.getServerHomeDir(), "data");
                System.setProperty("jboss.server.data.dir", this.serverDataDir.toString());
            }
        }
        return this.serverDataDir;
    }

    public File getServerNativeDir() {
        String fileName = System.getProperty("jboss.native.dir");
        if (fileName != null) {
            return new File(fileName);
        }
        return new File(this.getServerTempDir(), "native");
    }

    public File getServerTempDeployDir() {
        return new File(this.getServerTempDir(), "deploy");
    }

    public URL getServerBaseURL() {
        if (this.serverBaseURL == null) {
            try {
                this.serverBaseURL = this.getURL("jboss.server.base.url");
                if (this.serverBaseURL == null) {
                    this.serverBaseURL = new URL(this.homeURL, "server/");
                }
                System.setProperty("jboss.server.base.url", this.serverBaseURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.serverBaseURL;
    }

    public URL getServerHomeURL() {
        if (this.serverHomeURL == null) {
            try {
                this.serverHomeURL = this.getURL("jboss.server.home.url");
                if (this.serverHomeURL == null) {
                    this.serverHomeURL = new URL(this.getServerBaseURL(), this.getServerName() + "/");
                }
                System.setProperty("jboss.server.home.url", this.serverHomeURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.serverHomeURL;
    }

    public URL getServerLibraryURL() {
        if (this.serverLibraryURL == null) {
            try {
                this.serverLibraryURL = this.getURL("jboss.server.lib.url");
                if (this.serverLibraryURL == null) {
                    this.serverLibraryURL = new URL(this.getServerHomeURL(), "lib/");
                }
                System.setProperty("jboss.server.lib.url", this.serverLibraryURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.serverLibraryURL;
    }

    public URL getServerConfigURL() {
        if (this.serverConfigURL == null) {
            try {
                this.serverConfigURL = this.getURL("jboss.server.config.url");
                if (this.serverConfigURL == null) {
                    this.serverConfigURL = new URL(this.getServerHomeURL(), "conf/");
                }
                System.setProperty("jboss.server.config.url", this.serverConfigURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.serverConfigURL;
    }

    public boolean getPlatformMBeanServer() {
        if (this.platformMBeanServer == null) {
            if (Java.isCompatible((int)6)) {
                String value = this.props.getProperty("jboss.platform.mbeanserver", new Boolean(false).toString());
                value = "".equals(value) ? "true" : value;
                this.platformMBeanServer = new Boolean(value);
            } else {
                this.platformMBeanServer = Boolean.FALSE;
            }
        }
        return this.platformMBeanServer;
    }

    public void setExitOnShutdown(boolean flag) {
        this.exitOnShutdown = Primitives.valueOf((boolean)flag);
    }

    public boolean getExitOnShutdown() {
        if (this.exitOnShutdown == null) {
            String value = this.props.getProperty("jboss.server.exitonshutdown", null);
            this.exitOnShutdown = value == null ? Primitives.valueOf((boolean)true) : new Boolean(value);
        }
        return this.exitOnShutdown;
    }

    public void setBlockingShutdown(boolean flag) {
        this.blockingShutdown = Primitives.valueOf((boolean)flag);
    }

    public boolean getBlockingShutdown() {
        if (this.blockingShutdown == null) {
            String value = this.props.getProperty("jboss.server.blockingshutdown", null);
            this.blockingShutdown = value == null ? Primitives.valueOf((boolean)false) : new Boolean(value);
        }
        return this.blockingShutdown;
    }

    public void setRequireJBossURLStreamHandlerFactory(boolean flag) {
        this.requireJBossURLStreamHandlerFactory = Primitives.valueOf((boolean)flag);
    }

    public boolean getRequireJBossURLStreamHandlerFactory() {
        if (this.requireJBossURLStreamHandlerFactory == null) {
            String value = this.props.getProperty("jboss.server.requirejbossurlstreamhandlerfactory", null);
            this.requireJBossURLStreamHandlerFactory = value == null ? Primitives.valueOf((boolean)true) : new Boolean(value);
        }
        return this.requireJBossURLStreamHandlerFactory;
    }

    public void setRootDeploymentFilename(String filename) {
        this.rootDeployableFilename = filename;
    }

    public String getRootDeploymentFilename() {
        if (this.rootDeployableFilename == null) {
            this.rootDeployableFilename = this.props.getProperty("jboss.server.root.deployment.filename", "jboss-service.xml");
        }
        return this.rootDeployableFilename;
    }

    private URL getURL(String name) throws MalformedURLException {
        String value = this.props.getProperty(name, null);
        if (value != null) {
            if (!value.endsWith("/")) {
                value = value + "/";
            }
            return new URL(value);
        }
        return null;
    }

    private File getFile(String name) {
        String value = this.props.getProperty(name, null);
        if (value != null) {
            try {
                File f = new File(value);
                return f.getCanonicalFile();
            }
            catch (IOException e) {
                return new File(value);
            }
        }
        return null;
    }
}

