/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.jmx;

import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class LazyMBeanServer
implements MBeanServer {
    private static MBeanServer registeredServer;
    private static MBeanServer theServer;
    private static MBeanServer platformServer;
    private static String defaultDomain;
    private static MBeanServerDelegate theDelegate;
    private static Set platformServerDomains;
    private static Set serverDomains;

    public static MBeanServer resetToJBossServer(MBeanServer server) throws Exception {
        MBeanServer coreServer = server;
        if (theDelegate != null) {
            Class[] sig = new Class[]{String.class, MBeanServer.class, MBeanServerDelegate.class};
            Object[] args = new Object[]{defaultDomain, null, theDelegate};
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> c = loader.loadClass("org.jboss.mx.server.MBeanServerImpl");
            Constructor<?> ctor = c.getConstructor(sig);
            coreServer = theServer = (MBeanServer)ctor.newInstance(args);
            String[] domains = theServer.getDomains();
            for (int n = 0; n < domains.length; ++n) {
                serverDomains.add(domains[n]);
            }
        }
        return coreServer;
    }

    public static MBeanServer getRegisteredMBeanServer(MBeanServer server) {
        MBeanServer outerServer = server;
        if (registeredServer != null) {
            outerServer = registeredServer;
        }
        return outerServer;
    }

    public static synchronized void reloadDomains() {
        int n;
        String[] domains = platformServer.getDomains();
        for (n = 0; n < domains.length; ++n) {
            platformServerDomains.add(domains[n]);
        }
        domains = theServer.getDomains();
        for (n = 0; n < domains.length; ++n) {
            serverDomains.add(domains[n]);
        }
    }

    LazyMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate) {
        defaultDomain = domain;
        platformServer = outer;
        theServer = outer;
        registeredServer = this;
        theDelegate = delegate;
        String[] domains = platformServer.getDomains();
        for (int n = 0; n < domains.length; ++n) {
            platformServerDomains.add(domains[n]);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.createMBean(className, name, null);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.getServer(name).createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.getServer(name).createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.getServer(name).createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return theServer.registerMBean(object, name);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        theServer.unregisterMBean(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        ObjectInstance oi = this.getServer(name).getObjectInstance(name);
        return oi;
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        Set<ObjectInstance> beans = platformServer.queryMBeans(name, query);
        Set<ObjectInstance> beans2 = theServer.queryMBeans(name, query);
        beans.addAll(beans2);
        return beans;
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        Set<ObjectName> names = platformServer.queryNames(name, query);
        Set<ObjectName> names2 = theServer.queryNames(name, query);
        names.addAll(names2);
        return names;
    }

    public boolean isRegistered(ObjectName name) {
        return this.getServer(name).isRegistered(name);
    }

    public Integer getMBeanCount() {
        return theServer.getMBeanCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.getServer(name).getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.getServer(name).getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.getServer(name).setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.getServer(name).setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object value = this.getServer(name).invoke(name, operationName, params, signature);
        return value;
    }

    public String getDefaultDomain() {
        return theServer.getDefaultDomain();
    }

    public String[] getDomains() {
        return theServer.getDomains();
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.getServer(name).addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.getServer(name).addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getServer(name).removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getServer(name).removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getServer(name).removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getServer(name).removeNotificationListener(name, listener, filter, handback);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanInfo info = null;
        try {
            info = this.getServer(name).getMBeanInfo(name);
        }
        catch (InstanceNotFoundException e) {
            LazyMBeanServer.reloadDomains();
            info = this.getServer(name).getMBeanInfo(name);
        }
        return info;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        boolean isInstanceOf = false;
        try {
            isInstanceOf = this.getServer(name).isInstanceOf(name, className);
        }
        catch (InstanceNotFoundException e) {
            LazyMBeanServer.reloadDomains();
            isInstanceOf = this.getServer(name).isInstanceOf(name, className);
        }
        return isInstanceOf;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return theServer.instantiate(className);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return theServer.instantiate(className, loaderName);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return theServer.instantiate(className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return theServer.instantiate(className, loaderName, params, signature);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.getServer(name).deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return theServer.deserialize(className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return theServer.deserialize(className, loaderName, data);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.getServer(mbeanName).getClassLoaderFor(mbeanName);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.getServer(loaderName).getClassLoader(loaderName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return theServer.getClassLoaderRepository();
    }

    private MBeanServer getServer(ObjectName name) {
        String domain;
        String string = domain = name != null ? name.getDomain() : "";
        if (serverDomains.contains(domain)) {
            return theServer;
        }
        if (platformServerDomains.contains(domain)) {
            return platformServer;
        }
        return theServer;
    }

    static {
        platformServerDomains = Collections.synchronizedSet(new HashSet());
        serverDomains = Collections.synchronizedSet(new HashSet());
    }
}

