/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    public static Class loadClass(String classname) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.loadClass(classname);
    }

    private Util() {
    }

    public static MapModifications diffNodeData(Map<Object, Object> pre, Map<Object, Object> post) {
        MapModifications mods = new MapModifications();
        for (Object key : post.keySet()) {
            if (pre.containsKey(key)) {
                if (post.get(key).equals(pre.get(key))) continue;
                mods.modifiedEntries.put(key, post.get(key));
                continue;
            }
            mods.addedEntries.put(key, post.get(key));
        }
        for (Object key : pre.keySet()) {
            if (post.containsKey(key)) continue;
            mods.removedEntries.put(key, pre.get(key));
        }
        return mods;
    }

    public static class MapModifications {
        public final Map<Object, Object> addedEntries = new HashMap<Object, Object>();
        public final Map<Object, Object> removedEntries = new HashMap<Object, Object>();
        public final Map<Object, Object> modifiedEntries = new HashMap<Object, Object>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapModifications that = (MapModifications)o;
            if (this.addedEntries != null ? !((Object)this.addedEntries).equals(that.addedEntries) : that.addedEntries != null) {
                return false;
            }
            if (this.modifiedEntries != null ? !((Object)this.modifiedEntries).equals(that.modifiedEntries) : that.modifiedEntries != null) {
                return false;
            }
            return !(this.removedEntries != null ? !((Object)this.removedEntries).equals(that.removedEntries) : that.removedEntries != null);
        }

        public int hashCode() {
            int result = this.addedEntries != null ? ((Object)this.addedEntries).hashCode() : 0;
            result = 31 * result + (this.removedEntries != null ? ((Object)this.removedEntries).hashCode() : 0);
            result = 31 * result + (this.modifiedEntries != null ? ((Object)this.modifiedEntries).hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Added Entries " + this.addedEntries + " Removeed Entries " + this.removedEntries + " Modified Entries " + this.modifiedEntries;
        }
    }
}

