/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.AsyncCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ChainingCacheLoader;

public class CacheLoaderManager {
    private static Log log = LogFactory.getLog(CacheLoaderManager.class);
    private CacheLoaderConfig config;
    private CacheSPI cache;
    private CacheLoader loader;
    private boolean fetchPersistentState;

    public void setConfig(CacheLoaderConfig config, CacheSPI cache) throws CacheException {
        this.config = config == null ? new CacheLoaderConfig() : config;
        this.cache = cache;
        try {
            this.loader = this.createCacheLoader();
        }
        catch (Exception e) {
            throw new CacheException("Unable to create cache loaders", e);
        }
    }

    private CacheLoader createCacheLoader() throws Exception {
        CacheLoader tmpLoader = null;
        ArrayList<CacheLoaderConfig.IndividualCacheLoaderConfig> finalConfigs = new ArrayList<CacheLoaderConfig.IndividualCacheLoaderConfig>();
        if (this.config.useChainingCacheLoader()) {
            tmpLoader = new ChainingCacheLoader();
            ChainingCacheLoader ccl = tmpLoader;
            Iterator<CacheLoaderConfig.IndividualCacheLoaderConfig> it = this.config.getIndividualCacheLoaderConfigs().iterator();
            int numLoadersWithFetchPersistentState = 0;
            while (it.hasNext()) {
                CacheLoaderConfig.IndividualCacheLoaderConfig cfg = it.next();
                if (cfg.isFetchPersistentState()) {
                    ++numLoadersWithFetchPersistentState;
                    this.fetchPersistentState = true;
                }
                if (numLoadersWithFetchPersistentState > 1) {
                    throw new Exception("Invalid cache loader configuration!!  Only ONE cache loader may have fetchPersistentState set to true.  Cache will not start!");
                }
                CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc = cfg.getSingletonStoreConfig();
                if (ssc != null && ssc.isSingletonStoreEnabled() && this.config.isShared()) {
                    throw new Exception("Invalid cache loader configuration!!  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!");
                }
                CacheLoader l = this.createCacheLoader(cfg, this.cache);
                cfg = l.getConfig();
                finalConfigs.add(cfg);
                ccl.addCacheLoader(l, cfg);
            }
        } else {
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = this.config.getIndividualCacheLoaderConfigs().get(0);
            tmpLoader = this.createCacheLoader(cfg, this.cache);
            finalConfigs.add(tmpLoader.getConfig());
            this.fetchPersistentState = cfg.isFetchPersistentState();
        }
        this.config.setIndividualCacheLoaderConfigs(finalConfigs);
        return tmpLoader;
    }

    private CacheLoader createCacheLoader(CacheLoaderConfig.IndividualCacheLoaderConfig cfg, CacheSPI cache) throws Exception {
        CacheLoader tmpLoader = this.createInstance(cfg.getClassName());
        if (tmpLoader != null) {
            CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc;
            if (cfg.isAsync()) {
                AsyncCacheLoader asyncDecorator = new AsyncCacheLoader(tmpLoader);
                tmpLoader = asyncDecorator;
            }
            if ((ssc = cfg.getSingletonStoreConfig()) != null && ssc.isSingletonStoreEnabled()) {
                CacheLoader decorator = this.createInstance(ssc.getSingletonStoreClass());
                if (decorator instanceof AbstractDelegatingCacheLoader) {
                    AbstractDelegatingCacheLoader singletonDecorator = (AbstractDelegatingCacheLoader)decorator;
                    singletonDecorator.setCacheLoader(tmpLoader);
                    tmpLoader = singletonDecorator;
                } else {
                    throw new Exception("Invalid cache loader configuration!! Singleton store implementation class must extend org.jboss.cache.loader.AbstractDelegatingCacheLoader");
                }
            }
            tmpLoader.setConfig(cfg);
            this.setCacheInLoader(cache, tmpLoader);
            if (cache != null && cache.getConfiguration().isUseRegionBasedMarshalling()) {
                tmpLoader.setRegionManager(cache.getRegionManager());
            }
        }
        return tmpLoader;
    }

    protected void setCacheInLoader(CacheSPI c, CacheLoader loader) {
        loader.setCache(c);
    }

    private CacheLoader createInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("instantiating class " + className));
        }
        Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(className);
        return (CacheLoader)cl.newInstance();
    }

    public void preloadCache() throws CacheException {
        if (this.config.getPreload() == null || this.config.getPreload().equals("")) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("preloading transient state from cache loader " + this.loader));
        }
        StringTokenizer st = new StringTokenizer(this.config.getPreload(), ",");
        long start = System.currentTimeMillis();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            Fqn<String> fqn = Fqn.fromString(tok.trim());
            if (log.isTraceEnabled()) {
                log.trace((Object)("preloading " + fqn));
            }
            this.preload(fqn, true, true);
        }
        long stop = System.currentTimeMillis();
        long total = stop - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("preloading transient state from cache loader was successful (in " + total + " milliseconds)"));
        }
    }

    public void preload(Fqn fqn, boolean preloadParents, boolean preloadChildren) throws CacheException {
        this.cache.getInvocationContext().getOptionOverrides().setSkipDataGravitation(true);
        this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
        this.cache.get(fqn, "bla");
        if (preloadParents) {
            Fqn<Object> tmp_fqn = Fqn.ROOT;
            for (int i = 0; i < fqn.size() - 1; ++i) {
                tmp_fqn = new Fqn<Object>(tmp_fqn, fqn.get(i));
                this.cache.get(tmp_fqn, "bla");
            }
        }
        if (preloadChildren) {
            Set<?> children = null;
            try {
                children = this.loader.getChildrenNames(fqn);
            }
            catch (Exception e) {
                throw new CacheException("Unable to preload from cache loader", e);
            }
            if (children != null) {
                for (Object aChildren : children) {
                    String child_name = (String)aChildren;
                    Fqn<Object> child_fqn = new Fqn<Object>(fqn, new Object[]{child_name});
                    this.preload(child_fqn, false, true);
                }
            }
        }
    }

    public CacheLoaderConfig getCacheLoaderConfig() {
        return this.config;
    }

    public CacheLoader getCacheLoader() {
        return this.loader;
    }

    public void setCacheLoader(CacheLoader loader) {
        this.loader = loader;
    }

    public boolean isPassivation() {
        return this.config.isPassivation();
    }

    public boolean isFetchPersistentState() {
        return this.fetchPersistentState;
    }

    public void stopCacheLoader() {
        if (this.loader == null) {
            throw new RuntimeException("Problem with configured cache loader - it has been set to null!");
        }
        this.loader.stop();
        this.loader.destroy();
    }

    public void startCacheLoader() throws CacheException {
        if (this.loader == null) {
            throw new RuntimeException("Improperly configured cache loader - cache loader is null!");
        }
        try {
            this.loader.create();
            this.loader.start();
            this.purgeLoaders(false);
        }
        catch (Exception e) {
            throw new CacheException("Unable to start cache loaders", e);
        }
    }

    public void purgeLoaders(boolean force) throws Exception {
        if (this.loader instanceof ChainingCacheLoader && !force) {
            ((ChainingCacheLoader)this.loader).purgeIfNecessary();
        } else {
            CacheLoaderConfig.IndividualCacheLoaderConfig first = this.getCacheLoaderConfig().getFirstCacheLoaderConfig();
            if (force || first != null && first.isPurgeOnStartup()) {
                this.loader.remove(Fqn.ROOT);
            }
        }
    }
}

