/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticNodeInterceptor
extends OptimisticInterceptor {
    private NodeFactory nodeFactory;
    private Notifier notifier;

    @Override
    public void setCache(CacheSPI c) {
        super.setCache(c);
        this.nodeFactory = c.getConfiguration().getRuntimeConfig().getNodeFactory();
        this.notifier = this.cache.getNotifier();
    }

    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        Object[] args = m.getArgs();
        Object result = null;
        if (MethodDeclarations.isCrudMethod(m.getMethodId())) {
            GlobalTransaction gtx = this.getGlobalTransaction(ctx);
            TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
            Fqn fqn = this.getFqn(args, m.getMethodId());
            WorkspaceNode workspaceNode = this.fetchWorkspaceNode(fqn, workspace, true);
            if (workspaceNode == null && m.getMethodId() == 34) {
                workspaceNode = this.fetchWorkspaceNode(this.getBackupFqn(args), workspace, true);
            }
            if (workspaceNode != null) {
                if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
                    if (ctx.isOriginLocal() && m.getMethodId() == 36) {
                        throw new CacheException("Setting a data version while performing a move() is not supported!!");
                    }
                    workspace.setVersioningImplicit(false);
                    DataVersion version = ctx.getOptionOverrides().getDataVersion();
                    workspaceNode.setVersion(version);
                    if (this.trace) {
                        this.log.trace((Object)("Setting versioning for node " + workspaceNode.getFqn() + " to explicit"));
                    }
                    workspaceNode.setVersioningImplicit(false);
                } else {
                    if (this.trace) {
                        this.log.trace((Object)("Setting versioning for node " + workspaceNode.getFqn() + " to implicit"));
                    }
                    workspaceNode.setVersioningImplicit(true);
                }
            } else if ((ctx.getOptionOverrides() == null || !ctx.getOptionOverrides().isFailSilently()) && MethodDeclarations.isPutMethod(m.getMethodId())) {
                throw new CacheException("Unable to set node version for " + fqn + ", node is null.");
            }
            switch (m.getMethodId()) {
                case 36: {
                    Fqn parentFqn = (Fqn)args[1];
                    this.moveNodeAndNotify(parentFqn, workspaceNode, workspace, ctx);
                    break;
                }
                case 1: {
                    this.putDataMapAndNotify((Map)args[2], false, workspace, workspaceNode, ctx);
                    break;
                }
                case 2: {
                    this.putDataMapAndNotify((Map)args[2], (Boolean)args[args.length - 1], workspace, workspaceNode, ctx);
                    break;
                }
                case 3: 
                case 45: {
                    Object key = args[2];
                    Object value = args[3];
                    result = this.putDataKeyValueAndNotify(key, value, workspace, workspaceNode, ctx);
                    break;
                }
                case 5: {
                    result = this.removeNode(workspace, workspaceNode, true, ctx);
                    break;
                }
                case 6: {
                    Object removeKey = args[2];
                    result = this.removeKeyAndNotify(removeKey, workspace, workspaceNode, ctx);
                    break;
                }
                case 7: {
                    this.removeDataAndNotify(workspace, workspaceNode, ctx);
                    break;
                }
                case 34: {
                    result = super.invoke(ctx);
                }
                default: {
                    if (!this.log.isWarnEnabled()) break;
                    this.log.warn((Object)("Cannot handle CRUD method " + (Object)((Object)m)));
                }
            }
            this.addToModificationList(gtx, m, ctx);
        } else {
            switch (m.getMethodId()) {
                case 26: {
                    result = this.getValueForKeyAndNotify(args, this.getTransactionWorkspace(this.getGlobalTransaction(ctx)), ctx);
                    break;
                }
                case 25: {
                    result = this.getKeysAndNotify(args, this.getTransactionWorkspace(this.getGlobalTransaction(ctx)), ctx);
                    break;
                }
                case 23: {
                    result = this.getChildNamesAndNotify(args, this.getTransactionWorkspace(this.getGlobalTransaction(ctx)), ctx);
                    break;
                }
                case 31: {
                    result = this.getNodeAndNotify(args, this.getTransactionWorkspace(this.getGlobalTransaction(ctx)), ctx);
                    break;
                }
                default: {
                    if (this.trace) {
                        this.log.trace((Object)("read Method " + (Object)((Object)m) + " called - Not handling, passing on."));
                    }
                    result = super.invoke(ctx);
                }
            }
        }
        return result;
    }

    private Fqn getFqn(Object[] args, int methodId) {
        return (Fqn)args[methodId == 36 ? 0 : 1];
    }

    private Fqn getBackupFqn(Object[] args) {
        return (Fqn)args[2];
    }

    private void addToModificationList(GlobalTransaction gtx, MethodCall m, InvocationContext ctx) {
        Option opt = ctx.getOptionOverrides();
        if (opt == null || !opt.isCacheModeLocal()) {
            this.txTable.addModification(gtx, m);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding Method " + (Object)((Object)m) + " to modification list"));
            }
        }
        if (this.cache.getCacheLoaderManager() != null) {
            this.txTable.addCacheLoaderModification(gtx, m);
        }
    }

    private void moveNodeAndNotify(Fqn parentFqn, WorkspaceNode node, TransactionWorkspace ws, InvocationContext ctx) {
        Fqn nodeFqn = node.getFqn();
        if (nodeFqn.isRoot()) {
            this.log.warn((Object)"Attempting to move the root node.  Not taking any action, treating this as a no-op.");
            return;
        }
        WorkspaceNode parent = this.fetchWorkspaceNode(parentFqn, ws, false);
        if (parent == null) {
            throw new NodeNotExistsException("Node " + parentFqn + " does not exist!");
        }
        WorkspaceNode oldParent = this.fetchWorkspaceNode(nodeFqn.getParent(), ws, false);
        if (oldParent == null) {
            throw new NodeNotExistsException("Node " + nodeFqn.getParent() + " does not exist!");
        }
        Object nodeName = nodeFqn.getLastElement();
        oldParent.removeChild(new Fqn<Object>(nodeName));
        Fqn<Object> nodeNewFqn = new Fqn<Object>(parent.getFqn(), nodeFqn.getLastElement());
        this.notifier.notifyNodeMoved(nodeFqn, nodeNewFqn, true, ctx);
        this.recursiveMoveNode(node, parent.getFqn(), ws);
        this.removeNode(ws, node, false, ctx);
        this.notifier.notifyNodeMoved(nodeFqn, nodeNewFqn, false, ctx);
    }

    private void recursiveMoveNode(WorkspaceNode node, Fqn newBase, TransactionWorkspace ws) {
        Fqn<Object> newFqn = new Fqn<Object>(newBase, node.getFqn().getLastElement());
        WorkspaceNode movedNode = this.fetchWorkspaceNode(newFqn, ws, true);
        movedNode.putAll(node.getData());
        for (Object n : node.getChildrenNames()) {
            WorkspaceNode child = this.fetchWorkspaceNode(new Fqn<Object>(node.getFqn(), n), ws, false);
            if (child == null) continue;
            this.recursiveMoveNode(child, newFqn, ws);
        }
    }

    private void putDataMapAndNotify(Map<Object, Object> data, boolean eraseExisitng, TransactionWorkspace workspace, WorkspaceNode workspaceNode, InvocationContext ctx) {
        if (workspaceNode == null) {
            throw new NodeNotExistsException("optimisticCreateIfNotExistsInterceptor should have created this node!");
        }
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), true, NodeModifiedEvent.ModificationType.PUT_MAP, workspaceNode.getData(), ctx);
        if (eraseExisitng) {
            workspaceNode.clearData();
        }
        workspaceNode.putAll(data);
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), false, NodeModifiedEvent.ModificationType.PUT_MAP, workspaceNode.getData(), ctx);
    }

    private Object putDataKeyValueAndNotify(Object key, Object value, TransactionWorkspace workspace, WorkspaceNode workspaceNode, InvocationContext ctx) {
        if (workspaceNode == null) {
            throw new NodeNotExistsException("optimisticCreateIfNotExistsInterceptor should have created this node!");
        }
        Map<Object, Object> addedData = Collections.singletonMap(key, value);
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), true, NodeModifiedEvent.ModificationType.PUT_DATA, workspaceNode.getData(), ctx);
        Object old = workspaceNode.put(key, value);
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), false, NodeModifiedEvent.ModificationType.PUT_DATA, addedData, ctx);
        return old;
    }

    private boolean removeNode(TransactionWorkspace workspace, WorkspaceNode workspaceNode, boolean notify, InvocationContext ctx) throws CacheException {
        if (workspaceNode == null) {
            return false;
        }
        Fqn parentFqn = workspaceNode.getFqn().getParent();
        WorkspaceNode parentNode = this.fetchWorkspaceNode(parentFqn, workspace, true);
        if (parentNode == null) {
            throw new NodeNotExistsException("Unable to find parent node with fqn " + parentFqn);
        }
        if (notify) {
            this.notifier.notifyNodeRemoved(workspaceNode.getFqn(), true, workspaceNode.getData(), ctx);
        }
        parentNode.removeChild(workspaceNode.getFqn().getLastElement());
        Fqn nodeFqn = workspaceNode.getFqn();
        SortedMap tailMap = workspace.getNodesAfter(workspaceNode.getFqn());
        for (WorkspaceNode toDelete : tailMap.values()) {
            if (!toDelete.getFqn().isChildOrEquals(nodeFqn)) break;
            if (this.trace) {
                this.log.trace((Object)("marking node " + toDelete.getFqn() + " as deleted"));
            }
            toDelete.markAsDeleted(true);
        }
        if (notify) {
            this.notifier.notifyNodeRemoved(workspaceNode.getFqn(), false, null, ctx);
        }
        return true;
    }

    private Object removeKeyAndNotify(Object removeKey, TransactionWorkspace workspace, WorkspaceNode workspaceNode, InvocationContext ctx) {
        if (workspaceNode == null) {
            return null;
        }
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), true, NodeModifiedEvent.ModificationType.REMOVE_DATA, workspaceNode.getData(), ctx);
        Object old = workspaceNode.remove(removeKey);
        workspace.addNode(workspaceNode);
        Map removedData = Collections.singletonMap(removeKey, old);
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), false, NodeModifiedEvent.ModificationType.REMOVE_DATA, removedData, ctx);
        return old;
    }

    private void removeDataAndNotify(TransactionWorkspace workspace, WorkspaceNode workspaceNode, InvocationContext ctx) {
        if (workspaceNode == null) {
            return;
        }
        HashMap data = new HashMap(workspaceNode.getData());
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), true, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
        workspaceNode.clearData();
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), false, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
    }

    private Object getValueForKeyAndNotify(Object[] args, TransactionWorkspace workspace, InvocationContext ctx) {
        Fqn fqn = (Fqn)args[0];
        Object key = args[1];
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.debug((Object)("Unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        this.notifier.notifyNodeVisited(fqn, true, ctx);
        Object val = workspaceNode.get(key);
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeVisited(fqn, false, ctx);
        return val;
    }

    private Object getNodeAndNotify(Object[] args, TransactionWorkspace workspace, InvocationContext ctx) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.trace((Object)("Unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        this.notifier.notifyNodeVisited(fqn, true, ctx);
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeVisited(fqn, false, ctx);
        return workspaceNode.getNode();
    }

    private Object getKeysAndNotify(Object[] args, TransactionWorkspace workspace, InvocationContext ctx) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.trace((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        this.notifier.notifyNodeVisited(fqn, true, ctx);
        Set keySet = workspaceNode.getKeys();
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeVisited(fqn, false, ctx);
        return keySet;
    }

    private Object getChildNamesAndNotify(Object[] args, TransactionWorkspace workspace, InvocationContext ctx) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.trace((Object)("Unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        this.notifier.notifyNodeVisited(fqn, true, ctx);
        Set<Object> nameSet = workspaceNode.getChildrenNames();
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeVisited(fqn, false, ctx);
        return nameSet;
    }

    private WorkspaceNode fetchWorkspaceNode(Fqn fqn, TransactionWorkspace workspace, boolean undeleteIfNecessary) {
        WorkspaceNode workspaceNode = workspace.getNode(fqn);
        if (workspaceNode == null) {
            NodeSPI node = this.cache.peek(fqn, true);
            if (node == null) {
                return null;
            }
            workspaceNode = this.nodeFactory.createWorkspaceNode(node, workspace);
            workspace.addNode(workspaceNode);
        }
        if (workspaceNode.isDeleted()) {
            if (this.trace) {
                this.log.trace((Object)("Node " + fqn + " has been deleted in the workspace."));
            }
            if (undeleteIfNecessary) {
                workspaceNode.markAsDeleted(false);
                WorkspaceNode parent = this.fetchWorkspaceNode(fqn.getParent(), workspace, true);
                parent.addChild(workspaceNode);
            } else {
                workspaceNode = null;
            }
        }
        if (workspaceNode != null && !(workspaceNode.getVersion() instanceof DefaultDataVersion)) {
            workspaceNode.setVersioningImplicit(false);
        }
        return workspaceNode;
    }
}

