/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGravitatorInterceptor
extends BaseRpcInterceptor {
    private BuddyManager buddyManager;
    private boolean syncCommunications = false;
    private Log log = LogFactory.getLog(DataGravitatorInterceptor.class);
    private Map transactionMods = new ConcurrentHashMap();

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.buddyManager = cache.getBuddyManager();
        this.syncCommunications = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_SYNC || this.configuration.getCacheMode() == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Invoked with method call " + (Object)((Object)m)));
        }
        if (MethodDeclarations.isBlockUnblockMethod(m.getMethodId()) || ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSkipDataGravitation()) {
            return super.invoke(ctx);
        }
        if (!MethodDeclarations.isTransactionLifecycleMethod(m.getMethodId())) {
            if (this.isGravitationEnabled(ctx) && MethodDeclarations.isGetMethod(m.getMethodId())) {
                Fqn fqn = this.extractFqn(m.getMethodId(), m.getArgs());
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Checking local existence of fqn " + fqn));
                }
                if (BuddyManager.isBackupFqn(fqn)) {
                    this.log.info((Object)"Is call for a backup Fqn, not performing any gravitation.  Direct calls on internal backup nodes are *not* supported.");
                } else if (this.cache.peek(fqn, false) == null) {
                    BackupData data;
                    if (this.localBackupExists(fqn)) {
                        this.log.trace((Object)"Gravitating from local backup tree");
                        data = this.localBackupGet(fqn, ctx);
                    } else {
                        this.log.trace((Object)"Gravitating from remote backup tree");
                        data = this.remoteBackupGet(fqn);
                    }
                    if (data != null) {
                        this.log.trace((Object)"Passing the put call locally to make sure state is persisted and ownership is correctly established.");
                        this.createNode(data.backupData, false);
                        this.cleanBackupData(data, ctx.getGlobalTransaction());
                    }
                }
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Suppressing data gravitation for this call.");
            }
        } else {
            try {
                switch (m.getMethodId()) {
                    case 10: 
                    case 18: {
                        Object o = super.invoke(ctx);
                        this.doPrepare(ctx.getGlobalTransaction());
                        return o;
                    }
                    case 12: {
                        this.transactionMods.remove(ctx.getGlobalTransaction());
                        return super.invoke(ctx);
                    }
                    case 11: {
                        this.doCommit(ctx.getGlobalTransaction());
                        this.transactionMods.remove(ctx.getGlobalTransaction());
                        return super.invoke(ctx);
                    }
                }
            }
            catch (Throwable throwable) {
                this.transactionMods.remove(ctx.getGlobalTransaction());
                throw throwable;
            }
        }
        return super.invoke(ctx);
    }

    private boolean isGravitationEnabled(InvocationContext ctx) {
        boolean enabled = ctx.isOriginLocal();
        if (enabled && !this.buddyManager.isAutoDataGravitation()) {
            enabled = ctx.getOptionOverrides().getForceDataGravitation();
        }
        return enabled;
    }

    private void doPrepare(GlobalTransaction gtx) throws Throwable {
        MethodCall cleanup = (MethodCall)((Object)this.transactionMods.get(gtx));
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Broadcasting prepare for cleanup ops " + (Object)((Object)cleanup)));
        }
        if (cleanup != null) {
            ArrayList<MethodCall> mods = new ArrayList<MethodCall>(1);
            mods.add(cleanup);
            MethodCall prepare = this.configuration.isNodeLockingOptimistic() ? MethodCallFactory.create(MethodDeclarations.optimisticPrepareMethod, gtx, mods, null, this.cache.getLocalAddress(), false) : MethodCallFactory.create(MethodDeclarations.prepareMethod, gtx, mods, this.cache.getLocalAddress(), this.syncCommunications);
            this.replicateCall(this.getMembersOutsideBuddyGroup(), prepare, this.syncCommunications);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Nothing to broadcast in prepare phase for gtx " + gtx));
        }
    }

    private void doCommit(GlobalTransaction gtx) throws Throwable {
        if (this.transactionMods.containsKey(gtx)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Broadcasting commit for gtx " + gtx));
            }
            this.replicateCall(this.getMembersOutsideBuddyGroup(), MethodCallFactory.create(MethodDeclarations.commitMethod, gtx), this.syncCommunications);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Nothing to broadcast in commit phase for gtx " + gtx));
        }
    }

    private List<Address> getMembersOutsideBuddyGroup() {
        ArrayList<Address> members = new ArrayList<Address>(this.cache.getMembers());
        members.remove(this.cache.getLocalAddress());
        members.removeAll(this.buddyManager.getBuddyAddresses());
        return members;
    }

    private BackupData remoteBackupGet(Fqn name) throws Exception {
        BackupData result = null;
        GravitateResult gr = this.gravitateData(name);
        if (gr.isDataFound()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Got response " + gr));
            }
            result = new BackupData(name, gr);
        }
        return result;
    }

    private void cleanBackupData(BackupData backup, GlobalTransaction gtx) throws Throwable {
        MethodCall cleanup = MethodCallFactory.create(MethodDeclarations.dataGravitationCleanupMethod, gtx, backup.primaryFqn, backup.backupFqn);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Performing cleanup on [" + backup.primaryFqn + "]"));
        }
        if (gtx == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Performing cleanup on [" + backup.backupFqn + "]"));
            }
            this.replicateCall(this.cache.getMembers(), cleanup, this.syncCommunications);
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Data gravitation performed under global transaction " + gtx + ".  Not broadcasting cleanups until the tx commits.  Adding to tx mod list instead."));
            }
            this.transactionMods.put(gtx, cleanup);
            TransactionEntry te = this.getTransactionEntry(gtx);
            te.addModification(cleanup);
        }
    }

    private GravitateResult gravitateData(Fqn fqn) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("cache=" + this.cache.getLocalAddress() + "; requesting data gravitation for Fqn " + fqn));
        }
        List<Address> mbrs = this.cache.getMembers();
        Boolean searchSubtrees = this.buddyManager.isDataGravitationSearchBackupTrees() ? Boolean.TRUE : Boolean.FALSE;
        MethodCall dGrav = MethodCallFactory.create(MethodDeclarations.dataGravitationMethod, fqn, searchSubtrees);
        List resps = this.cache.getRPCManager().callRemoteMethods(mbrs, dGrav, 2, true, (long)this.buddyManager.getBuddyCommunicationTimeout());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("got responses " + resps));
        }
        if (resps == null) {
            this.log.error((Object)("No replies to call " + (Object)((Object)dGrav) + ".  Perhaps we're alone in the cluster?"));
            return GravitateResult.noDataFound();
        }
        GravitateResult result = GravitateResult.noDataFound();
        for (Object o : resps) {
            if (o instanceof Throwable) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"Found remote Throwable among responses - removing from responses list", (Throwable)((Exception)o));
                continue;
            }
            if (o != null) {
                result = (GravitateResult)o;
                if (!result.isDataFound()) continue;
                break;
            }
            if (this.configuration.isUseRegionBasedMarshalling()) continue;
            this.log.error((Object)("Unexpected null response to call " + (Object)((Object)dGrav) + "."));
        }
        return result;
    }

    private void createNode(List<NodeData> nodeData, boolean localOnly) throws CacheException {
        for (NodeData data : nodeData) {
            if (localOnly) {
                if (this.cache.peek(data.getFqn(), false) != null) continue;
                this.createNodesLocally(data.getFqn(), data.getAttributes());
                continue;
            }
            this.cache.put(data.getFqn(), data.getAttributes());
        }
    }

    private void createNodesLocally(Fqn fqn, Map data) throws CacheException {
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        NodeSPI n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize; ++i) {
            Object child_name = fqn.get(i);
            NodeSPI child_node = n.addChildDirect(new Fqn<Object>(child_name));
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            if (i == treeNodeSize - 1) {
                child_node.putAllDirect(data);
            }
            n = child_node;
        }
    }

    private TransactionEntry getTransactionEntry(GlobalTransaction gtx) {
        return this.cache.getTransactionTable().get(gtx);
    }

    private Fqn extractFqn(int methodId, Object[] args) {
        return (Fqn)args[MethodDeclarations.isCrudMethod(methodId) ? 1 : 0];
    }

    private boolean localBackupExists(Fqn fqn) {
        Node node;
        Fqn newSearchFqn;
        boolean exists = false;
        Iterator<Node> i$ = this.getBackupRootCollection().iterator();
        while (i$.hasNext() && !(exists = this.cache.peek(newSearchFqn = new Fqn((node = i$.next()).getFqn(), fqn), false) != null)) {
        }
        return exists;
    }

    private BackupData localBackupGet(Fqn fqn, InvocationContext ctx) throws CacheException {
        GravitateResult result = this.cache.gravitateData(fqn, true);
        boolean found = result.isDataFound();
        BackupData data = null;
        if (found) {
            Fqn backupFqn = result.getBuddyBackupFqn();
            data = new BackupData(fqn, result);
            if (this.buddyManager.isDataGravitationRemoveOnFind()) {
                ctx.getOptionOverrides().setCacheModeLocal(true);
                this.cache.removeNode(backupFqn);
            } else {
                this.cache.evict(backupFqn, true);
            }
        }
        return data;
    }

    private Collection<Node> getBackupRootCollection() {
        NodeSPI backupRoot = this.cache.peek(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, true);
        return backupRoot == null ? Collections.EMPTY_SET : backupRoot.getChildrenDirect();
    }

    private static class BackupData {
        Fqn primaryFqn;
        Fqn backupFqn;
        List<NodeData> backupData;

        public BackupData(Fqn primaryFqn, GravitateResult gr) {
            this.primaryFqn = primaryFqn;
            this.backupFqn = gr.getBuddyBackupFqn();
            this.backupData = gr.getNodeData();
        }
    }
}

