/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnversionedNode<K, V>
extends AbstractNode<K, V>
implements NodeSPI<K, V> {
    private static final int INDENT = 4;
    private static Log log = LogFactory.getLog(UnversionedNode.class);
    private boolean childrenLoaded = false;
    private boolean dataLoaded = true;
    private transient IdentityLock lock_ = null;
    private transient CacheImpl<K, V> cache;
    private final Map<K, V> data = new HashMap();

    public UnversionedNode() {
        this.fqn = Fqn.ROOT;
    }

    protected UnversionedNode(Object child_name, Fqn fqn, Map<K, V> data, boolean mapSafe, CacheSPI<K, V> cache) {
        this.init(child_name, fqn, cache);
        if (data != null) {
            this.data.putAll(data);
        }
    }

    private void init(Object child_name, Fqn fqn, CacheSPI<K, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("no cache init for " + fqn);
        }
        this.cache = (CacheImpl)cache;
        this.fqn = fqn;
        if (!fqn.isRoot() && !child_name.equals(fqn.getLastElement())) {
            throw new IllegalArgumentException("Child " + child_name + " must be last part of " + fqn);
        }
    }

    @Override
    public NodeSPI<K, V> getParent() {
        if (this.fqn.isRoot()) {
            return null;
        }
        return this.cache.peek(this.fqn.getParent(), true);
    }

    private synchronized void initLock() {
        if (this.lock_ == null) {
            this.lock_ = new IdentityLock(this.cache.getConfiguration().getIsolationLevel(), (NodeSPI)this);
        }
    }

    private synchronized Map<Object, Node<K, V>> children() {
        if (this.children == null) {
            this.children = this.getFqn().isRoot() ? new ConcurrentHashMap(64, 0.5f, 16) : new ConcurrentHashMap(4, 0.75f, 4);
        }
        return this.children;
    }

    @Override
    public CacheSPI<K, V> getCache() {
        return this.cache;
    }

    @Override
    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    @Override
    public void setChildrenLoaded(boolean flag) {
        this.childrenLoaded = flag;
    }

    @Override
    public V get(K key) {
        return this.cache.get(this.getFqn(), key);
    }

    @Override
    public V getDirect(K key) {
        return this.data == null ? null : (V)this.data.get(key);
    }

    private boolean isReadLocked() {
        return this.lock_ != null && this.lock_.isReadLocked();
    }

    private boolean isWriteLocked() {
        return this.lock_ != null && this.lock_.isWriteLocked();
    }

    @Override
    public IdentityLock getLock() {
        this.initLock();
        return this.lock_;
    }

    @Override
    public Map<K, V> getData() {
        if (this.cache == null) {
            return Collections.emptyMap();
        }
        return this.cache.getData(this.getFqn());
    }

    @Override
    public Map<K, V> getDataDirect() {
        if (this.data == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.data);
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(this.getFqn(), key, value);
    }

    @Override
    public V putDirect(K key, V value) {
        return this.data.put(key, value);
    }

    @Override
    public NodeSPI getOrCreateChild(Object child_name, GlobalTransaction gtx) {
        return this.getOrCreateChild(child_name, gtx, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeSPI getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean createIfNotExists) {
        if (child_name == null) {
            throw new IllegalArgumentException("null child name");
        }
        NodeSPI child = (NodeSPI)this.children().get(child_name);
        InvocationContext ctx = this.cache.getInvocationContext();
        if (createIfNotExists && child == null) {
            Fqn<Object> child_fqn = new Fqn<Object>(this.fqn, child_name);
            NodeSPI newChild = (NodeSPI)this.cache.getConfiguration().getRuntimeConfig().getNodeFactory().createNode(child_name, this, null);
            if (newChild == null) {
                throw new IllegalStateException();
            }
            UnversionedNode unversionedNode = this;
            synchronized (unversionedNode) {
                child = (NodeSPI)this.children().get(child_name);
                if (child == null) {
                    this.cache.getNotifier().notifyNodeCreated(child_fqn, true, ctx);
                    child = newChild;
                    this.children.put(child_name, child);
                    if (gtx != null) {
                        MethodCall undo_op = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, gtx, child_fqn, false);
                        this.cache.addUndoOperation(gtx, undo_op);
                    }
                }
            }
            if (newChild == child) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("created child: fqn=" + child_fqn));
                }
                this.cache.getNotifier().notifyNodeCreated(child_fqn, false, ctx);
            }
        }
        return child;
    }

    @Override
    public V remove(K key) {
        return this.cache.remove(this.getFqn(), key);
    }

    @Override
    public V removeDirect(K key) {
        if (this.data == null) {
            return null;
        }
        return this.data.remove(key);
    }

    @Override
    public void printDetails(StringBuffer sb, int indent) {
        this.printDetailsInMap(sb, indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        if (this.deleted) {
            sb.append(" (deleted) [ ").append(this.fqn);
        } else {
            sb.append("[ ").append(this.fqn);
        }
        if (this.data != null) {
            Map<K, V> map = this.data;
            synchronized (map) {
                sb.append(" data=").append(this.data.keySet());
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            sb.append(" child=").append(this.getChildrenNamesDirect());
        }
        if (this.lock_ != null) {
            if (this.isReadLocked()) {
                sb.append(" RL");
            }
            if (this.isWriteLocked()) {
                sb.append(" WL");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Node<K, V> addChild(Fqn f) {
        Fqn nf = new Fqn(this.getFqn(), f);
        this.cache.put(nf, null);
        return this.getChild(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildDirect(NodeSPI<K, V> child) {
        if (child.getFqn().getParent().equals(this.getFqn())) {
            UnversionedNode unversionedNode = this;
            synchronized (unversionedNode) {
                this.children().put(child.getFqn().getLastElement(), child);
            }
        } else {
            throw new CacheException("Attempting to add a child [" + child.getFqn() + "] to [" + this.getFqn() + "].  Can only add direct children.");
        }
    }

    @Override
    public NodeSPI<K, V> addChildDirect(Fqn f) {
        if (f.size() == 1) {
            GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
            return this.getOrCreateChild(f.getLastElement(), gtx);
        }
        throw new UnsupportedOperationException("Cannot directly create children which aren't directly under the current node.");
    }

    @Override
    public void clearData() {
        this.cache.removeData(this.getFqn());
    }

    @Override
    public void clearDataDirect() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    @Override
    public Node<K, V> getChild(Fqn fqn) {
        return this.cache.get(new Fqn(this.getFqn(), fqn));
    }

    @Override
    public NodeSPI<K, V> getChildDirect(Fqn fqn) {
        if (fqn.size() == 1) {
            return this.getChildDirect(fqn.getLastElement());
        }
        NodeSPI<K, V> currentNode = this;
        for (int i = 0; i < fqn.size(); ++i) {
            Object nextChildName = fqn.get(i);
            if ((currentNode = currentNode.getChildDirect(nextChildName)) != null) continue;
            return null;
        }
        return currentNode;
    }

    @Override
    public Set<Object> getChildrenNames() {
        return this.cache.getChildrenNames(this.getFqn());
    }

    @Override
    public Set<Object> getChildrenNamesDirect() {
        return this.children == null ? Collections.emptySet() : new HashSet(this.children.keySet());
    }

    @Override
    public Set<K> getKeys() {
        Set<K> keys = this.cache.getKeys(this.getFqn());
        return keys == null ? Collections.emptySet() : Collections.unmodifiableSet(keys);
    }

    @Override
    public Set<K> getKeysDirect() {
        if (this.data == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<K>(this.data.keySet()));
    }

    @Override
    public boolean hasChild(Fqn f) {
        return this.getChild(f) != null;
    }

    @Override
    public boolean hasChild(Object o) {
        return this.getChild(o) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K k, V v) {
        UnversionedNode unversionedNode = this;
        synchronized (unversionedNode) {
            if (!this.getKeys().contains(k)) {
                return this.put(k, v);
            }
            return this.get(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        UnversionedNode unversionedNode = this;
        synchronized (unversionedNode) {
            if (this.getKeys().contains(key)) {
                return this.put(key, value);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        UnversionedNode unversionedNode = this;
        synchronized (unversionedNode) {
            if (oldValue.equals(this.get(key))) {
                this.put(key, newValue);
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean removeChild(Fqn fqn) {
        return this.cache.removeNode(new Fqn(this.getFqn(), fqn));
    }

    @Override
    public int dataSize() {
        return this.cache.getKeys(this.getFqn()).size();
    }

    @Override
    public boolean removeChild(Object childName) {
        return this.removeChild((Fqn)new Fqn<Object>(this.getFqn(), childName));
    }

    @Override
    public boolean removeChildDirect(Object childName) {
        return this.children != null && this.children.remove(childName) != null;
    }

    @Override
    public boolean removeChildDirect(Fqn f) {
        if (f.size() == 1) {
            return this.removeChildDirect(f.getLastElement());
        }
        NodeSPI<K, V> child = this.getChildDirect(f);
        return child != null && child.getParent().removeChildDirect(f.getLastElement());
    }

    @Override
    public Map<Object, Node<K, V>> getChildrenMapDirect() {
        return this.children;
    }

    @Override
    public void setChildrenMapDirect(Map<Object, Node<K, V>> children) {
        this.children().clear();
        this.children.putAll(children);
    }

    @Override
    public void putAll(Map data) {
        this.cache.put(this.fqn, data);
    }

    @Override
    public void replaceAll(Map data) {
        this.cache.put((Fqn<?>)this.fqn, data, true);
    }

    @Override
    public void putAllDirect(Map<K, V> data) {
        if (data == null) {
            return;
        }
        this.data.putAll(data);
    }

    @Override
    public void removeChildrenDirect() {
        if (this.children != null) {
            this.children.clear();
        }
        this.children = null;
    }

    @Override
    public void print(StringBuffer sb, int indent) {
        this.printIndent(sb, indent);
        sb.append("/").append(this.getName()).append(" ").append(this.getDataDirect().size());
        if (this.children != null) {
            for (Node node : this.children.values()) {
                sb.append("\n");
                ((NodeSPI)node).print(sb, indent + 4);
            }
        }
    }

    @Override
    public void setVersion(DataVersion version) {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    @Override
    public DataVersion getVersion() {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    private void printIndent(StringBuffer sb, int indent) {
        if (sb != null) {
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
        }
    }

    @Override
    public void addChild(Object child_name, Node<K, V> n) {
        if (child_name != null) {
            this.children().put(child_name, n);
        }
    }

    private Object getName() {
        return this.fqn.getLastElement();
    }

    @Override
    public Fqn getFqn() {
        return this.fqn;
    }

    @Override
    public void setFqn(Fqn fqn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.getFqn() + " set FQN " + fqn));
        }
        this.fqn = fqn;
        if (this.children == null) {
            return;
        }
        for (Map.Entry me : this.children.entrySet()) {
            NodeSPI n = (NodeSPI)me.getValue();
            Fqn<Object> cfqn = new Fqn<Object>(fqn, me.getKey());
            n.setFqn(cfqn);
        }
    }

    @Override
    public Node<K, V> getChild(Object childName) {
        return this.cache.get(new Fqn<Object>(this.getFqn(), childName));
    }

    @Override
    public NodeSPI<K, V> getChildDirect(Object childName) {
        if (childName == null) {
            return null;
        }
        return (NodeSPI)(this.children == null ? null : (Node)this.children.get(childName));
    }

    @Override
    public Set<Node<K, V>> getChildren() {
        if (this.cache == null) {
            return Collections.emptySet();
        }
        HashSet<Node<K, V>> children = new HashSet<Node<K, V>>();
        for (Object c : this.cache.getChildrenNames(this.getFqn())) {
            Node<K, V> n = this.cache.get(new Fqn<Object>(this.getFqn(), c));
            if (n == null) continue;
            children.add(n);
        }
        return Collections.unmodifiableSet(children);
    }

    @Override
    public Set<NodeSPI<K, V>> getChildrenDirect() {
        if (this.children == null || this.children.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<NodeSPI> exclDeleted = new HashSet<NodeSPI>();
        for (Node n : this.children.values()) {
            NodeSPI spi = (NodeSPI)n;
            if (spi.isDeleted()) continue;
            exclDeleted.add(spi);
        }
        return Collections.unmodifiableSet(exclDeleted);
    }

    @Override
    public boolean hasChildrenDirect() {
        return this.children != null && this.children.size() != 0;
    }

    @Override
    public Set<NodeSPI<K, V>> getChildrenDirect(boolean includeMarkedForRemoval) {
        if (includeMarkedForRemoval) {
            if (this.children != null && !this.children.isEmpty()) {
                return Collections.unmodifiableSet(new HashSet(this.children.values()));
            }
            return Collections.emptySet();
        }
        return this.getChildrenDirect();
    }

    private void printDetailsInMap(StringBuffer sb, int indent) {
        this.printIndent(sb, indent);
        indent += 2;
        if (!this.getFqn().isRoot()) {
            sb.append("/");
        }
        sb.append(this.getName());
        sb.append("  ");
        sb.append(this.data);
        if (this.children != null) {
            for (Node n : this.children.values()) {
                sb.append("\n");
                ((NodeSPI)n).printDetails(sb, indent);
            }
        }
    }

    @Override
    public boolean isDataLoaded() {
        return this.dataLoaded;
    }

    @Override
    public void setDataLoaded(boolean dataLoaded) {
        this.dataLoaded = dataLoaded;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

