/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.transaction.DummyTransaction;

public class DummyBaseTransactionManager
implements TransactionManager,
Serializable {
    static ThreadLocal thread_local = new ThreadLocal();

    public void begin() throws NotSupportedException, SystemException {
        Transaction currentTx = this.getTransaction();
        if (currentTx != null) {
            throw new NotSupportedException(Thread.currentThread() + " is already associated with a transaction (" + currentTx + ")");
        }
        DummyTransaction tx = new DummyTransaction(this);
        this.setTransaction(tx);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("thread not associated with transaction");
        }
        int status = tx.getStatus();
        if (status == 1) {
            throw new RollbackException();
        }
        tx.commit();
        this.setTransaction(null);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("no transaction associated with thread");
        }
        tx.rollback();
        this.setTransaction(null);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("no transaction associated with calling thread");
        }
        tx.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public Transaction getTransaction() throws SystemException {
        return (Transaction)thread_local.get();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("not supported");
    }

    public Transaction suspend() throws SystemException {
        Transaction retval = this.getTransaction();
        this.setTransaction(null);
        return retval;
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.setTransaction(tx);
    }

    void setTransaction(Transaction tx) {
        thread_local.set(tx);
    }
}

