/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.lock.LockMap;
import org.jboss.cache.lock.LockStrategy;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.OwnerNotExistedException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.lock.UpgradeException;
import org.jboss.logging.Logger;

public class IdentityLock {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$cache$lock$IdentityLock == null ? (class$org$jboss$cache$lock$IdentityLock = IdentityLock.class$("org.jboss.cache.lock.IdentityLock")) : class$org$jboss$cache$lock$IdentityLock));
    private LockStrategy lock_;
    private LockMap map_;
    private TreeCache cache_;
    private transient Fqn fqn;
    static /* synthetic */ Class class$org$jboss$cache$lock$IdentityLock;

    public IdentityLock(TreeCache cache, Fqn fqn) {
        this.cache_ = cache;
        this.fqn = fqn;
        if (this.cache_ == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache instance is null. Use default lock strategy");
            }
            this.lock_ = LockStrategyFactory.getLockStrategy();
        } else {
            this.lock_ = LockStrategyFactory.getLockStrategy(this.cache_.getIsolationLevelClass());
        }
        this.map_ = new LockMap();
        this.cache_ = cache;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public List getReaderOwners() {
        return this.map_.readerOwners();
    }

    public Object getWriterOwner() {
        return this.map_.writerOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireWriteLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (caller == null) {
            throw new IllegalArgumentException("acquireWriteLock(): null caller");
        }
        IdentityLock identityLock = this;
        synchronized (identityLock) {
            if (this.map_.isOwner(caller, 2)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("acquireWriteLock(): caller already owns lock for " + this.fqn + " (caller=" + caller + ")"));
                }
                return false;
            }
        }
        if (this.map_.isOwner(caller, 1)) {
            Sync wLock = null;
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("upgrading RL to WL for " + caller + ", timeout=" + timeout + ", locks: " + this.map_.printInfo()));
                }
                wLock = this.lock_.upgradeLockAttempt(timeout);
            }
            catch (UpgradeException ue) {
                String errStr = "acquireWriteLock(): lock upgrade failed for " + this.fqn + " (caller=" + caller + ")";
                log.error((Object)errStr, (Throwable)((Object)ue));
                throw new UpgradeException(errStr, (Throwable)((Object)ue));
            }
            if (wLock == null) {
                this.release(caller);
                this.map_.removeReader(caller);
                String errStr = "upgrade lock for " + this.fqn + " could not be acquired after " + timeout + " ms." + " Lock map ownership " + this.map_.printInfo() + " (caller=" + caller + ")";
                log.error((Object)errStr);
                throw new UpgradeException(errStr);
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("upgrading lock for " + this.fqn));
                }
                this.map_.upgrade(caller);
            }
            catch (OwnerNotExistedException ex) {
                throw new UpgradeException("Can't upgrade lock to WL for " + this.fqn + ", error in LockMap.upgrade(): " + (Object)((Object)ex));
            }
        }
        boolean rc = this.lock_.writeLock().attempt(timeout);
        if (!rc) {
            String errStr = "write lock for " + this.fqn + " could not be acquired after " + timeout + " ms. " + "Locks: " + this.map_.printInfo() + " (caller=" + caller + ", lock info: " + this.toString(true) + ")";
            log.error((Object)errStr);
            throw new TimeoutException(errStr);
        }
        this.map_.addWriter(caller);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireReadLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (caller == null) {
            throw new IllegalArgumentException("owner is null");
        }
        IdentityLock identityLock = this;
        synchronized (identityLock) {
            if (this.map_.isOwner(caller, 0)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("acquireReadLock(): caller " + caller + " already owns lock for " + this.fqn));
                }
                return false;
            }
        }
        boolean rc = this.lock_.readLock().attempt(timeout);
        if (!rc) {
            String errStr = "read lock for " + this.fqn + " could not be acquired by " + caller + " after " + timeout + " ms. " + "Locks: " + this.map_.printInfo() + ", lock info: " + this.toString(true);
            log.error((Object)errStr);
            throw new TimeoutException(errStr);
        }
        this.map_.addReader(caller);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object caller) {
        if (caller == null) {
            throw new IllegalArgumentException("IdentityLock.release(): null owner object.");
        }
        IdentityLock identityLock = this;
        synchronized (identityLock) {
            if (this.map_.isOwner(caller, 1)) {
                this.map_.removeReader(caller);
                this.lock_.readLock().release();
            } else if (this.map_.isOwner(caller, 2)) {
                this.map_.removeWriter(caller);
                this.lock_.writeLock().release();
            }
        }
    }

    public void releaseAll() {
        Object obj = null;
        List col = null;
        obj = this.map_.writerOwner();
        if (obj != null) {
            this.lock_.writeLock().release();
            this.map_.removeWriter(obj);
        }
        if ((col = this.map_.readerOwners()).size() != 0) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                this.lock_.readLock().release();
            }
            col.clear();
        }
    }

    public void releaseForce() {
        this.releaseAll();
    }

    public boolean isReadLocked() {
        return this.map_.readerOwners().size() != 0;
    }

    public boolean isWriteLocked() {
        return this.map_.writerOwner() != null;
    }

    public boolean isLocked() {
        return this.isReadLocked() || this.isWriteLocked();
    }

    public boolean isOwner(Object o) {
        return this.map_.isOwner(o, 0);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean print_lock_details) {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, print_lock_details);
        return sb.toString();
    }

    public void toString(StringBuffer sb) {
        this.toString(sb, false);
    }

    public synchronized void toString(StringBuffer sb, boolean print_lock_details) {
        Object write_owner;
        ArrayList read_owners;
        boolean printed_read_owners = false;
        ArrayList arrayList = read_owners = this.lock_ != null ? new ArrayList(this.getReaderOwners()) : null;
        if (read_owners != null && read_owners.size() > 0) {
            sb.append("read owners=").append(read_owners);
            printed_read_owners = true;
        } else {
            read_owners = null;
        }
        Object object = write_owner = this.lock_ != null ? this.getWriterOwner() : null;
        if (write_owner != null) {
            if (printed_read_owners) {
                sb.append(", ");
            }
            sb.append("write owner=").append(write_owner);
        }
        if (read_owners == null && write_owner == null) {
            sb.append("<unlocked>");
        }
        if (print_lock_details) {
            sb.append(" (").append(this.lock_.toString()).append(")");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

