/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.ConByConJoinPointGenerator;
import org.jboss.aop.instrument.ConByMethodJoinPointGenerator;
import org.jboss.aop.instrument.GeneratedAdvisorCallerInfoAdder;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodByConJoinPointGenerator;
import org.jboss.aop.instrument.MethodByMethodJoinPointGenerator;
import org.jboss.aop.instrument.MethodExecutionTransformer;

public class GeneratedAdvisorCallerTransformer
extends CallerTransformer {
    public GeneratedAdvisorCallerTransformer(Instrumentor instrumentor, AspectManager manager) {
        super(instrumentor, manager, true, new GeneratedAdvisorCallerInfoAdder(instrumentor));
    }

    private GeneratedAdvisorInstrumentor getInstrumentor() {
        return (GeneratedAdvisorInstrumentor)this.instrumentor;
    }

    private CtClass getGenadvisor() {
        return this.getInstrumentor().getGenadvisor();
    }

    protected CallerTransformer.CallerExprEditor callerExprEditorFactory(ClassAdvisor advisor, CtClass clazz) {
        return new GeneratedAdvisorCallerExprEditor(advisor, clazz);
    }

    private String getArguments(int length, int offset) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < length - offset; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("$" + (i + 1 + offset));
        }
        return sb.toString();
    }

    class GeneratedAdvisorCallerExprEditor
    extends CallerTransformer.CallerExprEditor {
        public GeneratedAdvisorCallerExprEditor(ClassAdvisor advisor, CtClass callingClass) {
            super(advisor, callingClass);
        }

        protected void setupConstructor(CallerTransformer.ConstructorDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                this.callerInfos.put(cd.callerInfoField, "whatever");
                GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addMethodByConInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, cd.callingIndex, cd.classname, cd.calledHash);
                this.addJoinpoint(cd);
                this.createGenAdvisorMethodByConMethod(cd);
            }
        }

        private void addJoinpoint(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException {
            CtClass joinpoint = this.createJoinpointClass(cd);
            CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
            CtField field = new CtField(joinpoint, MethodByConJoinPointGenerator.getInfoFieldName(cd.callingIndex, cd.classname, cd.calledHash), genadvisor);
            field.setModifiers(4);
            genadvisor.addField(field);
        }

        private CtClass createJoinpointClass(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException {
            return MethodByConJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingIndex, this.callingClass, cd.calledMethod, cd.classname, cd.calledHash, cd.callerInfoField);
        }

        private void createGenAdvisorMethodByConMethod(CallerTransformer.ConstructorDetail cd) throws NotFoundException, CannotCompileException {
            boolean hasTargetObject = !Modifier.isStatic((int)cd.calledMethod.getModifiers());
            int originalLength = cd.calledMethod.getParameterTypes().length;
            CtClass[] params = null;
            if (hasTargetObject) {
                params = new CtClass[originalLength + 1];
                params[0] = GeneratedAdvisorCallerTransformer.this.instrumentor.forName(cd.classname);
                System.arraycopy(cd.calledMethod.getParameterTypes(), 0, params, 1, originalLength);
            } else {
                params = cd.calledMethod.getParameterTypes();
            }
            String proceed = null;
            proceed = hasTargetObject ? MethodExecutionTransformer.getAopReturnStr(cd.calledMethod) + "$1." + cd.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, 1) + ");" : MethodExecutionTransformer.getAopReturnStr(cd.calledMethod) + cd.classname + "." + cd.calledMethod.getName() + "($$);";
            String infoName = MethodByConJoinPointGenerator.getInfoFieldName(cd.callingIndex, cd.classname, cd.calledHash);
            String generatorName = MethodByConJoinPointGenerator.getJoinPointGeneratorFieldName(cd.callingIndex, cd.classname, cd.calledHash);
            String code = "{   if (" + infoName + " == null && " + generatorName + " != null)" + "   {" + "   " + generatorName + "." + "generateJoinPointClass" + "(this.getClass().getClassLoader());" + "   }" + "   if (" + infoName + " == null)" + "   { " + "      " + proceed + "   }" + "   else" + "   {" + "      return " + infoName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
            try {
                CtMethod method = CtNewMethod.make((CtClass)cd.calledMethod.getReturnType(), (String)cd.callerInfoField, (CtClass[])params, (CtClass[])cd.calledMethod.getExceptionTypes(), (String)code, (CtClass)GeneratedAdvisorCallerTransformer.this.getGenadvisor());
                GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
            }
            catch (CannotCompileException e) {
                System.out.println("Error for " + cd.callingIndex + " code:" + code);
                throw e;
            }
        }

        protected void setupMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(md.callerInfoField) == null) {
                this.callerInfos.put(md.callerInfoField, "whatever");
                GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addMethodByMethodInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), md.callerInfoField, md.callingHash, md.classname, md.calledHash);
                this.addJoinpoint(md);
                this.createGenAdvisorMethodByMethodMethod(md);
            }
        }

        private void addJoinpoint(CallerTransformer.MethodDetail md) throws CannotCompileException, NotFoundException {
            CtClass joinpoint = this.createJoinpointClass(md);
            CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
            CtField field = new CtField(joinpoint, MethodByMethodJoinPointGenerator.getInfoFieldName(md.callingHash, md.classname, md.calledHash), genadvisor);
            field.setModifiers(4);
            genadvisor.addField(field);
        }

        private CtClass createJoinpointClass(CallerTransformer.MethodDetail md) throws CannotCompileException, NotFoundException {
            return MethodByMethodJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), md.callingHash, !Modifier.isStatic((int)md.where.getModifiers()), this.callingClass, md.calledMethod, md.classname, md.calledHash, md.callerInfoField);
        }

        private void createGenAdvisorMethodByMethodMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException {
            boolean hasCallingObject = !Modifier.isStatic((int)md.where.getModifiers());
            boolean hasTargetObject = !Modifier.isStatic((int)md.calledMethod.getModifiers());
            int originalLength = md.calledMethod.getParameterTypes().length;
            int offset = 0;
            if (hasTargetObject) {
                ++offset;
            }
            if (hasCallingObject) {
                ++offset;
            }
            CtClass[] params = new CtClass[originalLength + offset];
            int index = 0;
            if (hasTargetObject) {
                params[index++] = GeneratedAdvisorCallerTransformer.this.instrumentor.forName(md.classname);
            }
            if (hasCallingObject) {
                params[index++] = this.callingClass;
            }
            System.arraycopy(md.calledMethod.getParameterTypes(), 0, params, offset, originalLength);
            String proceed = null;
            proceed = hasTargetObject ? MethodExecutionTransformer.getAopReturnStr(md.calledMethod) + "$1." + md.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 2 : 1) + ");" : MethodExecutionTransformer.getAopReturnStr(md.calledMethod) + md.classname + "." + md.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 1 : 0) + ");";
            String infoName = MethodByMethodJoinPointGenerator.getInfoFieldName(md.callingHash, md.classname, md.calledHash);
            String generatorName = MethodByMethodJoinPointGenerator.getJoinPointGeneratorFieldName(md.callingHash, md.classname, md.calledHash);
            String code = "{   if (" + infoName + " == null && " + generatorName + " != null)" + "   {" + "   " + generatorName + "." + "generateJoinPointClass" + "(this.getClass().getClassLoader());" + "   }" + "   if (" + infoName + " == null)" + "   { " + "      " + proceed + "   }" + "   else" + "   {" + "      " + MethodExecutionTransformer.getReturnStr(md.calledMethod) + infoName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
            try {
                CtMethod method = CtNewMethod.make((CtClass)md.calledMethod.getReturnType(), (String)md.callerInfoField, (CtClass[])params, (CtClass[])md.calledMethod.getExceptionTypes(), (String)code, (CtClass)GeneratedAdvisorCallerTransformer.this.getGenadvisor());
                GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
            }
            catch (CannotCompileException e) {
                System.out.println("Error for " + md.where + " code:" + code);
                throw e;
            }
        }

        protected void setupMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                this.callerInfos.put(cd.callerInfoField, "whatever");
                GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addConByMethodInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, cd.callingHash, cd.classname, cd.calledHash);
                this.addJoinpoint(cd);
                this.createGenAdvisorConByMethodMethod(cd);
            }
        }

        private void addJoinpoint(CallerTransformer.ConByMethodDetail cd) throws CannotCompileException, NotFoundException {
            CtClass joinpoint = this.createJoinpointClass(cd);
            CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
            CtField field = new CtField(joinpoint, ConByMethodJoinPointGenerator.getInfoFieldName(cd.callingHash, cd.classname, cd.calledHash), genadvisor);
            field.setModifiers(4);
            genadvisor.addField(field);
        }

        private CtClass createJoinpointClass(CallerTransformer.ConByMethodDetail cd) throws CannotCompileException, NotFoundException {
            return ConByMethodJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingHash, !Modifier.isStatic((int)cd.where.getModifiers()), this.callingClass, cd.calledConstructor, cd.classname, cd.calledHash, cd.callerInfoField);
        }

        private void createGenAdvisorConByMethodMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            boolean hasCallingObject = !Modifier.isStatic((int)cd.where.getModifiers());
            String info = cd.callerInfoField;
            int originalLength = cd.calledConstructor.getParameterTypes().length;
            CtClass[] params = null;
            if (hasCallingObject) {
                params = new CtClass[originalLength + 1];
                params[0] = this.callingClass;
                System.arraycopy(cd.calledConstructor.getParameterTypes(), 0, params, 1, originalLength);
            } else {
                params = cd.calledConstructor.getParameterTypes();
            }
            String infoName = ConByMethodJoinPointGenerator.getInfoFieldName(cd.callingHash, cd.classname, cd.calledHash);
            String generatorName = ConByMethodJoinPointGenerator.getJoinPointGeneratorFieldName(cd.callingHash, cd.classname, cd.calledHash);
            StringBuffer code = new StringBuffer();
            code.append("{");
            code.append("   if (" + infoName + " == null && " + generatorName + " != null)");
            code.append("   {");
            code.append("   " + generatorName + "." + "generateJoinPointClass" + "(this.getClass().getClassLoader());");
            code.append("   }");
            code.append("   if (" + infoName + " == null)");
            code.append("   { ");
            code.append("      return new " + cd.calledConstructor.getDeclaringClass().getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 1 : 0) + "); ");
            code.append("   }");
            code.append("   else");
            code.append("   {");
            code.append("      return " + infoName + "." + "invokeJoinpoint" + "($$);");
            code.append("   }");
            code.append("}");
            try {
                CtMethod method = CtNewMethod.make((CtClass)cd.calledConstructor.getDeclaringClass(), (String)info, (CtClass[])params, (CtClass[])cd.calledConstructor.getExceptionTypes(), (String)code.toString(), (CtClass)GeneratedAdvisorCallerTransformer.this.getGenadvisor());
                GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
            }
            catch (CannotCompileException e) {
                System.out.println("Error for " + cd.where + ": code:" + code);
                throw e;
            }
        }

        protected void setupConstructor(CallerTransformer.ConByConDetail cd) throws NotFoundException, CannotCompileException {
            if (this.callerInfos.get(cd.callerInfoField) == null) {
                this.callerInfos.put(cd.callerInfoField, "whatever");
                GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addConByConInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, cd.callingIndex, cd.classname, cd.calledHash);
                this.addJoinpoint(cd);
                this.createGenAdvisorConByConMethod(cd);
            }
        }

        private void addJoinpoint(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            CtClass joinpoint = this.createJoinpointClass(cd);
            CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
            CtField field = new CtField(joinpoint, ConByConJoinPointGenerator.getInfoFieldName(cd.callingIndex, cd.classname, cd.calledHash), genadvisor);
            field.setModifiers(4);
            genadvisor.addField(field);
        }

        private CtClass createJoinpointClass(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            return ConByConJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingIndex, this.callingClass, cd.calledConstructor, cd.classname, cd.calledHash, cd.callerInfoField);
        }

        private void createGenAdvisorConByConMethod(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            String infoName = ConByConJoinPointGenerator.getInfoFieldName(cd.callingIndex, cd.classname, cd.calledHash);
            String generatorName = ConByConJoinPointGenerator.getJoinPointGeneratorFieldName(cd.callingIndex, cd.classname, cd.calledHash);
            String code = "{   if (" + infoName + " == null && " + generatorName + " != null)" + "   {" + "   " + generatorName + "." + "generateJoinPointClass" + "(this.getClass().getClassLoader());" + "   }" + "   if (" + infoName + " == null)" + "   { " + "      return new " + cd.calledConstructor.getDeclaringClass().getName() + "($$); " + "   }" + "   else" + "   {" + "      return " + infoName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
            try {
                CtMethod method = CtNewMethod.make((CtClass)cd.calledConstructor.getDeclaringClass(), (String)cd.callerInfoField, (CtClass[])cd.calledConstructor.getParameterTypes(), (CtClass[])cd.calledConstructor.getExceptionTypes(), (String)code, (CtClass)GeneratedAdvisorCallerTransformer.this.getGenadvisor());
                GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
            }
            catch (CannotCompileException e) {
                System.out.println("Error for " + cd.callingIndex + " code:" + code);
                throw e;
            }
        }

        protected void replaceMethodCallInCon(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException {
            String advisor = " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "aop$classAdvisor$aop" + ")";
            int paramsLength = cd.calledMethod.getParameterTypes().length;
            String args = null;
            args = Modifier.isStatic((int)cd.calledMethod.getModifiers()) ? (paramsLength > 0 ? "$$" : "") : "$0" + (paramsLength > 0 ? ", $$" : "");
            String ret = !cd.calledMethod.getReturnType().equals(CtClass.voidType) ? "$_ = " : "";
            String replaced = ret + advisor + "." + cd.callerInfoField + "(" + args + ");";
            try {
                cd.call.replace(replaced);
            }
            catch (CannotCompileException e) {
                System.out.println("Error for " + cd.con + " code:" + replaced);
                throw e;
            }
        }

        protected void replaceMethodCallInMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException {
            boolean hasCallingObject = !Modifier.isStatic((int)md.where.getModifiers());
            boolean hasTargetObject = !Modifier.isStatic((int)md.calledMethod.getModifiers());
            int paramsLength = md.calledMethod.getParameterTypes().length;
            String args = null;
            args = hasCallingObject && hasTargetObject ? "$0, this" + (paramsLength > 0 ? ", $$" : "") : (!hasCallingObject && hasTargetObject ? "$0" + (paramsLength > 0 ? ", $$" : "") : (hasCallingObject && !hasTargetObject ? "this" + (paramsLength > 0 ? ", $$" : "") : "$$"));
            String advisor = hasCallingObject ? "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")" : " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "aop$classAdvisor$aop" + ")";
            String ret = md.calledMethod.getReturnType().equals(CtClass.voidType) ? "" : "$_ = ";
            String replaced = ret + advisor + "." + md.callerInfoField + "(" + args + ");";
            try {
                md.call.replace(replaced);
            }
            catch (CannotCompileException e) {
                System.out.println("Error for " + md.where + " code:" + replaced);
                throw e;
            }
        }

        protected void replaceConCallInMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException {
            int paramsLength = cd.calledConstructor.getParameterTypes().length;
            String args = null;
            String advisor = null;
            if (!Modifier.isStatic((int)cd.where.getModifiers())) {
                args = "this" + (paramsLength > 0 ? ", $$" : "");
                advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")";
            } else {
                args = paramsLength > 0 ? "$$" : "";
                advisor = " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "aop$classAdvisor$aop" + ")";
            }
            String replaced = "$_ = " + advisor + "." + cd.callerInfoField + "(" + args + ");";
            try {
                cd.call.replace(replaced);
            }
            catch (CannotCompileException e) {
                System.out.println("Error for " + cd.where + " code:" + replaced);
                throw e;
            }
        }

        protected void replaceConCallInCon(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException {
            String advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "aop$classAdvisor$aop" + ")";
            String replaced = "$_ = " + advisor + "." + cd.callerInfoField + "($$);";
            try {
                cd.call.replace(replaced);
            }
            catch (CannotCompileException e) {
                System.out.println("Error for " + cd.callingIndex + " code:" + replaced);
                throw e;
            }
        }
    }
}

