/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Joinpoint;

public abstract class JoinPointInfo {
    private Interceptor[] interceptors;
    private ArrayList interceptorChain = new ArrayList();
    private WeakReference advisor;
    protected volatile Joinpoint joinpoint;
    protected WeakReference clazz;

    protected JoinPointInfo() {
        this.clazz = new WeakReference<Object>(null);
    }

    protected JoinPointInfo(Advisor advisor, Class clazz) {
        this.setAdvisor(advisor);
        this.clazz = new WeakReference<Class>(clazz);
    }

    protected JoinPointInfo(JoinPointInfo other) {
        this.advisor = other.advisor;
        if (other.interceptors != null) {
            this.interceptors = new Interceptor[other.interceptors.length];
            System.arraycopy(other.interceptors, 0, this.interceptors, 0, other.interceptors.length);
        }
        if (other.interceptorChain != null) {
            this.interceptorChain = (ArrayList)this.interceptorChain.clone();
        }
    }

    protected void clear() {
        this.interceptorChain.clear();
        this.interceptors = null;
    }

    public Advisor getAdvisor() {
        if (this.advisor == null) {
            return null;
        }
        return (Advisor)this.advisor.get();
    }

    public Class getClazz() {
        return (Class)this.clazz.get();
    }

    public void setAdvisor(Advisor advisor) {
        this.advisor = new WeakReference<Advisor>(advisor);
    }

    public boolean hasAdvices() {
        return this.interceptors != null && this.interceptors.length > 0;
    }

    public boolean equalChains(JoinPointInfo other) {
        if (this.interceptors == null && other.interceptors == null) {
            return true;
        }
        if (this.interceptors == null || other.interceptors == null) {
            return false;
        }
        if (this.interceptors.length != other.interceptors.length) {
            return false;
        }
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i].equals(other.interceptors[i])) continue;
            return false;
        }
        return true;
    }

    public Joinpoint getJoinpoint() {
        if (this.joinpoint == null) {
            this.joinpoint = this.internalGetJoinpoint();
        }
        return this.joinpoint;
    }

    public ArrayList getInterceptorChain() {
        return this.interceptorChain;
    }

    public void setInterceptorChain(ArrayList interceptorChain) {
        this.interceptorChain = interceptorChain;
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    protected abstract Joinpoint internalGetJoinpoint();

    public abstract JoinPointInfo copy();
}

