/*
 * Decompiled with CFR 0.152.
 */
package javax.websocket.server;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfiguration;

public abstract class ServerEndpointConfigurator {
    private ServerEndpointConfigurator containerDefaultConfigurator;

    static ServerEndpointConfigurator fetchContainerDefaultConfigurator() {
        Iterator<ServerEndpointConfigurator> i$ = ServiceLoader.load(ServerEndpointConfigurator.class).iterator();
        if (i$.hasNext()) {
            ServerEndpointConfigurator impl = i$.next();
            return impl;
        }
        throw new RuntimeException("Cannot load platform configurator");
    }

    ServerEndpointConfigurator getContainerDefaultConfigurator() {
        if (this.containerDefaultConfigurator == null) {
            this.containerDefaultConfigurator = ServerEndpointConfigurator.fetchContainerDefaultConfigurator();
        }
        return this.containerDefaultConfigurator;
    }

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        return this.getContainerDefaultConfigurator().getNegotiatedSubprotocol(supported, requested);
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        return this.getContainerDefaultConfigurator().getNegotiatedExtensions(installed, requested);
    }

    public boolean checkOrigin(String originHeaderValue) {
        return this.getContainerDefaultConfigurator().checkOrigin(originHeaderValue);
    }

    public boolean matchesURI(String path, URI requestUri, Map<String, String> templateExpansion) {
        return this.getContainerDefaultConfigurator().matchesURI(path, requestUri, templateExpansion);
    }

    public void modifyHandshake(ServerEndpointConfiguration sec, HandshakeRequest request, HandshakeResponse response) {
    }
}

