/*
 * Decompiled with CFR 0.152.
 */
package javax.websocket.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfiguration;
import javax.websocket.server.ServerEndpointConfigurator;

final class DefaultServerEndpointConfiguration
implements ServerEndpointConfiguration {
    private String path;
    private Class<?> endpointClass;
    private List<String> subprotocols;
    private List<Extension> extensions;
    private List<Encoder> encoders;
    private List<Decoder> decoders;
    private Map<String, Object> userProperties = new HashMap<String, Object>();
    private ServerEndpointConfigurator serverEndpointConfigurator;

    DefaultServerEndpointConfiguration(Class endpointClass, String path, List<String> subprotocols, List<Extension> extensions, List<Encoder> encoders, List<Decoder> decoders, ServerEndpointConfigurator serverEndpointConfigurator) {
        this.path = path;
        this.endpointClass = endpointClass;
        this.subprotocols = Collections.unmodifiableList(subprotocols);
        this.extensions = Collections.unmodifiableList(extensions);
        this.encoders = Collections.unmodifiableList(encoders);
        this.decoders = Collections.unmodifiableList(decoders);
        this.serverEndpointConfigurator = serverEndpointConfigurator == null ? ServerEndpointConfigurator.fetchContainerDefaultConfigurator() : serverEndpointConfigurator;
    }

    @Override
    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    DefaultServerEndpointConfiguration(Class<? extends Endpoint> endpointClass, String path) {
        this.path = path;
        this.endpointClass = endpointClass;
    }

    @Override
    public List<Encoder> getEncoders() {
        return this.encoders;
    }

    @Override
    public List<Decoder> getDecoders() {
        return this.decoders;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public ServerEndpointConfigurator getServerEndpointConfigurator() {
        return this.serverEndpointConfigurator;
    }

    @Override
    public final Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    @Override
    public final List<String> getSubprotocols() {
        return this.subprotocols;
    }

    @Override
    public final List<Extension> getExtensions() {
        return this.extensions;
    }
}

