/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat, Inc. and/or its affiliates, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package javax.validation;

import javax.validation.metadata.ElementDescriptor;

/**
 * Represents the navigation path from an object to another
 * in an object graph.
 * Each path element is represented by a {@code Node}.
 *
 * The path corresponds to the succession of nodes
 * in the order they are returned by the {@code Iterator}
 *
 * @author Emmanuel Bernard
 * @author Gunnar Morling
 */
public interface Path extends Iterable<Path.Node> {

	/**
	 * Represents an element of a navigation path.
	 */
	interface Node {
		/**
		 * Name of the property, constructor, method or parameter which the node
		 * represents or null if representing an entity on the leaf node or the
		 * return value of a constructor or method (in particular the node in a
		 * {@code Path} representing the root object has its name null).
		 *
		 * @return Name of the property, constructor, method or parameter which
		 *         the node represents.
		 */
		String getName();

		/**
		 * @return true if the node represents an object contained in an Iterable
		 *         or in a Map.
		 */
		boolean isInIterable();

		/**
		 * @return The index the node is placed in if contained
		 *         in an array or List. Null otherwise.
		 */
		Integer getIndex();

		/**
		 * @return The key the node is placed in if contained
		 *         in a Map. Null otherwise.
		 */
		Object getKey();

		/**
		 * Returns a descriptor for the element (bean, property, method etc.)
		 * represented by this node. The specific type of the element can be
		 * determined using {@link ElementDescriptor#getKind()}.
		 *
		 * @return An element descriptor for this node.
		 *
		 * @since 1.1
		 */
		ElementDescriptor getElementDescriptor();
	}
}
