/*
 * @(#)RowSetReader.java	1.1 99/05/11
 * 
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * 
 */

package javax.sql;

import java.sql.*;

/**
 * <P>An object implementing the RowSetReader interface may be registered with 
 * a RowSet object that supports the reader/writer paradigm.  A RowSetReader object 
 * is called by a rowset to produce a new set of rows which will become 
 * the rowset's contents.  
 */

public interface RowSetReader {

  /**
   * <P>Read the new contents of a rowset.  This method is invoked internally
   * by the RowSet.execute() method for rowsets that support the
   * reader/writer paradigm.
   * 
   * <P>The readData() method uses the RowSet.insertRow() or RowSet.populate()
   * methods to add rows to the caller.  In general, any of the caller's
   * methods may be called by the reader with one exception, calling
   * execute() will throw an SQLException since execute may not be called
   * recursively.  Also, rowset events, such as RowSetChanged, etc. are not
   * generated by RowSet methods invoked by a reader.
   * 
   * @param caller the rowset that called the reader
   * @exception SQLException if a database-access error occurs 
   */
  void readData(RowSetInternal caller) throws SQLException;

}
