/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryRounding;
import javax.money.RoundingContext;
import javax.money.RoundingContextBuilder;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryRoundingsSingletonSpi;
import javax.money.spi.RoundingProviderSpi;

public final class DefaultMonetaryRoundingsSingletonSpi
implements MonetaryRoundingsSingletonSpi {
    private static final MonetaryRounding DEFAULT_ROUNDING = new DefaultCurrencyRounding();

    public RoundingQueryBuilder createRoundingQueryBuilder() {
        throw new IllegalStateException("No MonetaryRoundingsSingletonSpi registered.");
    }

    @Override
    public MonetaryRounding getDefaultRounding() {
        return DEFAULT_ROUNDING;
    }

    @Override
    public Collection<MonetaryRounding> getRoundings(RoundingQuery query) {
        ArrayList<MonetaryRounding> result = new ArrayList<MonetaryRounding>();
        List<String> providerNames = query.getProviderNames();
        if (providerNames == null || providerNames.isEmpty()) {
            providerNames = this.getDefaultProviderChain();
        }
        for (String providerName : providerNames) {
            Bootstrap.getServices(RoundingProviderSpi.class).stream().filter(prov -> providerName.equals(prov.getProviderName())).forEach(prov -> {
                try {
                    MonetaryRounding r = prov.getRounding(query);
                    if (r != null) {
                        result.add(r);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(DefaultMonetaryRoundingsSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
                }
            });
        }
        return result;
    }

    @Override
    public Set<String> getProviderNames() {
        HashSet<String> result = new HashSet<String>();
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                result.add(prov.getProviderName());
            }
            catch (Exception e) {
                Logger.getLogger(Monetary.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
            }
        }
        return result;
    }

    @Override
    public List<String> getDefaultProviderChain() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Monetary.getRoundingProviderNames());
        Collections.sort(result);
        return result;
    }

    @Override
    public Set<String> getRoundingNames(String ... providers) {
        HashSet<String> result = new HashSet<String>();
        String[] providerNames = providers;
        if (providerNames.length == 0) {
            providerNames = Monetary.getDefaultRoundingProviderChain().toArray(new String[Monetary.getDefaultRoundingProviderChain().size()]);
        }
        for (String providerName : providerNames) {
            for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
                try {
                    if (!prov.getProviderName().equals(providerName) && !prov.getProviderName().matches(providerName)) continue;
                    result.addAll(prov.getRoundingNames());
                }
                catch (Exception e) {
                    Logger.getLogger(DefaultMonetaryRoundingsSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
                }
            }
        }
        return result;
    }

    private static final class DefaultCurrencyRounding
    implements MonetaryRounding,
    Serializable {
        private static final long serialVersionUID = 8641545296538357839L;
        private static final RoundingContext ROUNDING_CONTEXT = RoundingContextBuilder.of("default", "default").build();

        private DefaultCurrencyRounding() {
        }

        @Override
        public MonetaryAmount apply(MonetaryAmount amount) {
            MonetaryRounding r = Monetary.getRounding(amount.getCurrency(), new String[0]);
            return r.apply(amount);
        }

        @Override
        public RoundingContext getRoundingContext() {
            return ROUNDING_CONTEXT;
        }
    }
}

