/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.spi.ServiceProvider;

public class DefaultServiceProvider
implements ServiceProvider {
    private Map<Class, List<Object>> servicesLoaded = new ConcurrentHashMap<Class, List<Object>>();

    @Override
    public <T> List<T> getServices(Class<T> serviceType) {
        return this.getServices(serviceType, Collections.emptyList());
    }

    @Override
    public <T> List<T> getServices(Class<T> serviceType, List<T> defaultList) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType, defaultList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> loadServices(Class<T> serviceType, List<T> defaultList) {
        List<Object> found = null;
        Map<Class, List<Object>> map = this.servicesLoaded;
        synchronized (map) {
            found = this.servicesLoaded.get(serviceType);
            if (found != null) {
                return found;
            }
            found = new ArrayList<Object>();
            this.servicesLoaded.put(serviceType, found);
        }
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                found.add(t);
            }
        }
        catch (Exception e) {
            Logger.getLogger(DefaultServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
        }
        return found;
    }

    public static final class ProviderComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object p1, Object p2) {
            return p1.getClass().getSimpleName().compareTo(p2.getClass().getSimpleName());
        }
    }
}

