/*
 * Decompiled with CFR 0.152.
 */
package javax.money.format;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.money.MonetaryException;
import javax.money.format.AmountStyle;
import javax.money.format.MonetaryAmountFormat;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFormatProviderSpi;

public final class MonetaryFormats {
    private MonetaryFormats() {
    }

    public static MonetaryAmountFormat getAmountFormat(Locale locale) {
        Objects.requireNonNull(locale, "Locale required");
        for (MonetaryAmountFormatProviderSpi spi : Bootstrap.getServices(MonetaryAmountFormatProviderSpi.class)) {
            MonetaryAmountFormat f = spi.getAmountFormat(AmountStyle.of(locale));
            if (f == null) continue;
            return f;
        }
        throw new MonetaryException("No MonetaryAmountFormat for locale " + locale);
    }

    public static MonetaryAmountFormat getAmountFormat(AmountStyle style) {
        Objects.requireNonNull(style, "AmountStyle required");
        for (MonetaryAmountFormatProviderSpi spi : Bootstrap.getServices(MonetaryAmountFormatProviderSpi.class)) {
            MonetaryAmountFormat f = spi.getAmountFormat(style);
            if (f == null) continue;
            return f;
        }
        throw new MonetaryException("No MonetaryAmountFormat for style " + style);
    }

    public static final Set<Locale> getAvailableLocales() {
        return AmountStyle.getAvailableLocales();
    }
}

