/*
 * Decompiled with CFR 0.152.
 */
package javax.money.format;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.format.AmountFormatSymbols;
import javax.money.format.CurrencyStyle;
import javax.money.spi.AmountStyleProviderSpi;
import javax.money.spi.Bootstrap;

public final class AmountStyle
implements Serializable {
    private static final long serialVersionUID = -7744853434156071725L;
    private String pattern;
    private MonetaryOperator displayConversion;
    private MonetaryOperator parseConversion;
    private int[] groupingSizes;
    private CurrencyStyle currencyStyle;
    private Locale locale;
    private AmountFormatSymbols symbols;

    private AmountStyle(Builder builder) {
        Objects.requireNonNull(builder.pattern, "Format pattern required.");
        Objects.requireNonNull(builder.symbols, "Symbols required.");
        Objects.requireNonNull(builder.currencyStyle, "currencyFormat required.");
        Objects.requireNonNull(builder.locale, "Locale required.");
        this.groupingSizes = builder.groupingSizes;
        this.displayConversion = builder.displayConversion;
        this.parseConversion = builder.parseConversion;
        this.pattern = builder.pattern;
        this.currencyStyle = builder.currencyStyle;
        this.locale = builder.locale;
        this.symbols = builder.symbols;
    }

    public static final AmountStyle of(Locale locale) {
        Objects.requireNonNull(locale, "Locale required.");
        for (AmountStyleProviderSpi spi : Bootstrap.getServices(AmountStyleProviderSpi.class)) {
            AmountStyle style = spi.getAmountStyle(locale);
            if (style == null) continue;
            return style;
        }
        throw new MonetaryException("No AmountStyle for locale " + locale);
    }

    public static final Set<Locale> getAvailableLocales() {
        HashSet<Locale> locales = new HashSet<Locale>();
        for (AmountStyleProviderSpi spi : Bootstrap.getServices(AmountStyleProviderSpi.class)) {
            locales.addAll(spi.getSupportedLocales());
        }
        return locales;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getLocalizedPattern() {
        return this.pattern;
    }

    public CurrencyStyle getCurrencyStyle() {
        return this.currencyStyle;
    }

    public AmountFormatSymbols getSymbols() {
        return this.symbols;
    }

    public MonetaryOperator getDisplayConversion() {
        return this.displayConversion;
    }

    public MonetaryOperator getParseConversion() {
        return this.parseConversion;
    }

    public int[] getGroupingSizes() {
        return (int[])this.groupingSizes.clone();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currencyStyle == null ? 0 : this.currencyStyle.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + Arrays.hashCode(this.groupingSizes);
        result = 31 * result + (this.displayConversion == null ? 0 : this.displayConversion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AmountStyle other = (AmountStyle)obj;
        if (this.currencyStyle != other.currencyStyle) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (!Arrays.equals(this.groupingSizes, other.groupingSizes)) {
            return false;
        }
        return !(this.displayConversion == null ? other.displayConversion != null : !this.displayConversion.equals(other.displayConversion));
    }

    public String toString() {
        return "AmountStyle [locale=" + this.locale + ", formatPattern=" + this.pattern + ", currencyStyle=" + (Object)((Object)this.currencyStyle) + ", rounding=" + this.displayConversion + ", groupSizes=" + Arrays.toString(this.groupingSizes) + "]";
    }

    public static final class Builder {
        private static final int[] EMPTY_INT_ARRAY = new int[0];
        private Locale locale;
        private String pattern;
        private MonetaryOperator displayConversion;
        private MonetaryOperator parseConversion;
        private int[] groupingSizes = EMPTY_INT_ARRAY;
        private AmountFormatSymbols symbols;
        private CurrencyStyle currencyStyle = CurrencyStyle.CODE;

        public Builder(AmountStyle style) {
            Objects.requireNonNull(style, "style required.");
            this.locale = style.locale;
            this.symbols = style.symbols;
            this.currencyStyle = style.currencyStyle;
            this.displayConversion = style.displayConversion;
            this.groupingSizes = style.groupingSizes;
            this.parseConversion = style.parseConversion;
            this.pattern = style.pattern;
        }

        public Builder(Locale locale) {
            Objects.requireNonNull(locale, "Locale required.");
            this.locale = locale;
            this.symbols = AmountFormatSymbols.of(locale);
        }

        public Builder setDisplayConversion(MonetaryOperator conversion) {
            this.displayConversion = conversion;
            return this;
        }

        public Builder setSymbols(AmountFormatSymbols symbols) {
            Objects.requireNonNull(symbols);
            this.symbols = symbols;
            return this;
        }

        public Builder setParseConversion(MonetaryOperator conversion) {
            this.parseConversion = conversion;
            return this;
        }

        public Builder setGroupingSizes(int ... groupSizes) {
            Objects.requireNonNull(groupSizes, "groupSizes required.");
            this.groupingSizes = groupSizes;
            return this;
        }

        public Builder setPattern(String pattern) {
            Objects.requireNonNull(pattern, "pattern required.");
            this.pattern = pattern;
            return this;
        }

        public Builder withSymbols(AmountFormatSymbols symbols) {
            Objects.requireNonNull(symbols, "symbols required.");
            this.symbols = symbols;
            return this;
        }

        public Builder setCurrencyStyle(CurrencyStyle currencyStyle) {
            Objects.requireNonNull(currencyStyle, "CurrencyStyle null.");
            this.currencyStyle = currencyStyle;
            return this;
        }

        public AmountStyle build() {
            return new AmountStyle(this);
        }

        public String toString() {
            return "FormatStyle.Builder [locale=" + this.locale + ", formatPattern=" + this.pattern + ", currencyFormat=" + (Object)((Object)this.currencyStyle) + ", rounding=" + this.displayConversion + ", groupSizes=" + Arrays.toString(this.groupingSizes) + ", symbols=" + this.symbols + "]";
        }
    }
}

