/*
 * Decompiled with CFR 0.152.
 */
package javax.money.format;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.money.MonetaryException;
import javax.money.spi.AmountFormatSymbolsProviderSpi;
import javax.money.spi.Bootstrap;

public final class AmountFormatSymbols
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5247515200471590539L;
    private char zeroDigit;
    private char[] groupingSeparators = new char[0];
    private char decimalSeparator;
    private char digit;
    private char patternSeparator;
    private String infinity;
    private String exponentialSeparator;
    private char minusSign;
    private Locale locale;

    private AmountFormatSymbols(Builder builder) {
        this.locale = builder.locale;
        this.groupingSeparators = builder.groupingSeparators;
        this.decimalSeparator = builder.decimalSeparator;
        this.digit = builder.digit;
        this.minusSign = builder.minusSign;
        this.patternSeparator = builder.patternSeparator;
        this.zeroDigit = builder.zeroDigit;
        this.exponentialSeparator = builder.exponentialSeparator;
        this.infinity = builder.infinity;
    }

    public static final AmountFormatSymbols of(Locale locale) {
        Objects.requireNonNull(locale, "Locale required.");
        for (AmountFormatSymbolsProviderSpi spi : Bootstrap.getServices(AmountFormatSymbolsProviderSpi.class)) {
            AmountFormatSymbols symbols = spi.getAmountFormatSymbols(locale);
            if (symbols == null) continue;
            return symbols;
        }
        throw new MonetaryException("No AmountFormatSymbols for locale " + locale);
    }

    public static final Set<Locale> getAvailableLocales() {
        HashSet<Locale> locales = new HashSet<Locale>();
        for (AmountFormatSymbolsProviderSpi spi : Bootstrap.getServices(AmountFormatSymbolsProviderSpi.class)) {
            locales.addAll(spi.getSupportedLocales());
        }
        return locales;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final Character getZeroDigit() {
        return Character.valueOf(this.zeroDigit);
    }

    public final char[] getGroupingSeparators() {
        return (char[])this.groupingSeparators.clone();
    }

    public final Character getDecimalSeparator() {
        return Character.valueOf(this.decimalSeparator);
    }

    public final Character getDigit() {
        return Character.valueOf(this.digit);
    }

    public final Character getPatternSeparator() {
        return Character.valueOf(this.patternSeparator);
    }

    public final String getInfinity() {
        return this.infinity;
    }

    public final Character getMinusSign() {
        return Character.valueOf(this.minusSign);
    }

    public final String getExponentSeparator() {
        return this.exponentialSeparator;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "MonetaryFormatSymbols [locale=" + this.locale + ", patternSeparator=" + this.patternSeparator + ", digit=" + this.digit + ", zeroDigit=" + this.zeroDigit + ", decimalSeparator=" + this.decimalSeparator + ", groupingSeparators=" + Arrays.toString(this.groupingSeparators) + ", minusSign=" + this.minusSign + ", exponentialSeparator=" + this.exponentialSeparator + "]";
    }

    public static final class Builder {
        private static final char PATTERN_ZERO_DIGIT = '0';
        private static final char PATTERN_DECIMAL_SEPARATOR = '.';
        private static final char PATTERN_DIGIT = '#';
        private static final char PATTERN_SEPARATOR = ';';
        private static final String PATTERN_EXPONENT = "E";
        private static final char PATTERN_MINUS = '-';
        private char zeroDigit = (char)48;
        private char[] groupingSeparators = new char[0];
        private char decimalSeparator = (char)46;
        private char digit = (char)35;
        private char patternSeparator = (char)59;
        private String infinity;
        private String exponentialSeparator = "E";
        private char minusSign = (char)45;
        private Locale locale;

        public Builder(Locale locale) {
            Objects.requireNonNull(locale);
            this.locale = locale;
        }

        public Builder(AmountFormatSymbols symbols) {
            Objects.requireNonNull(symbols);
            this.locale = symbols.locale;
            this.decimalSeparator = symbols.decimalSeparator;
            this.digit = symbols.digit;
            this.groupingSeparators = symbols.groupingSeparators;
            this.minusSign = symbols.minusSign;
            this.patternSeparator = symbols.patternSeparator;
            this.zeroDigit = symbols.zeroDigit;
        }

        public Builder setZeroDigit(char zeroDigit) {
            this.zeroDigit = zeroDigit;
            return this;
        }

        public Builder setGroupingSeparator(char ... groupingSeparators) {
            Objects.requireNonNull(groupingSeparators);
            this.groupingSeparators = groupingSeparators;
            return this;
        }

        public Builder setDecimalSeparator(char decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
            return this;
        }

        public Builder setExponentialSeparator(String exponentialSeparator) {
            this.exponentialSeparator = exponentialSeparator;
            return this;
        }

        public Builder setInfinity(String infinity) {
            this.infinity = infinity;
            return this;
        }

        public Builder setDigit(char digit) {
            this.digit = digit;
            return this;
        }

        public Builder setPatternSeparator(char patternSeparator) {
            this.patternSeparator = patternSeparator;
            return this;
        }

        public Builder setMinusSign(char minusSign) {
            this.minusSign = minusSign;
            return this;
        }

        public AmountFormatSymbols create() {
            return new AmountFormatSymbols(this);
        }

        public String toString() {
            return "MonetaryFormatSymbols.Builder [locale=" + this.locale + ", patternSeparator=" + this.patternSeparator + ", digit=" + this.digit + ", zeroDigit=" + this.zeroDigit + ", decimalSeparator=" + this.decimalSeparator + ", groupingSeparators=" + Arrays.toString(this.groupingSeparators) + ", minusSign=" + this.minusSign + "]";
        }
    }
}

