/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.money.AbstractContext;
import javax.money.convert.ConversionContext;
import javax.money.convert.RateType;

public final class ProviderContext
extends AbstractContext {
    private static final long serialVersionUID = 3536713139786856877L;

    private ProviderContext(Builder builder) {
        super(builder);
    }

    public String getProviderName() {
        return this.getNamedAttribute(String.class, (Object)ProviderAttribute.PROVIDER);
    }

    public Set<RateType> getRateTypes() {
        return this.getNamedAttribute(Set.class, (Object)ProviderAttribute.RATE_TYPES);
    }

    public <T> T getValidFrom(Class<T> type) {
        return this.getNamedAttribute(type, (Object)ProviderAttribute.VALID_FROM);
    }

    public Long getValidFromMillis() {
        return this.getNamedAttribute(Long.class, (Object)ProviderAttribute.VALID_FROM);
    }

    public <T> T getValidTo(Class<T> type) {
        return this.getNamedAttribute(type, (Object)ProviderAttribute.VALID_TO);
    }

    public Long getValidToMillis() {
        return this.getNamedAttribute(Long.class, (Object)ProviderAttribute.VALID_TO);
    }

    public boolean isInScope(long timestamp) {
        Long validTo = this.getValidTo(Long.class);
        Long validFrom = this.getValidFrom(Long.class);
        if (validTo != null && validTo <= timestamp) {
            return false;
        }
        return validFrom == null || validFrom <= timestamp;
    }

    public boolean hasLowerBound() {
        return this.getValidFrom(Long.class) != null;
    }

    public boolean hasUpperBound() {
        return this.getValidTo(Long.class) != null;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProviderContext of(String provider, RateType ... rateTypes) {
        return new Builder(provider).setRateTypes(rateTypes).create();
    }

    public static ProviderContext of(String provider) {
        return new Builder(provider).setRateTypes(RateType.ANY).create();
    }

    public static ProviderContext from(ConversionContext conversionContext) {
        return ((Builder)new Builder(conversionContext.getProvider()).setRateTypes(conversionContext.getRateType()).setAll(conversionContext)).setProviderName(conversionContext.getProvider()).create();
    }

    public static final class Builder
    extends AbstractContext.AbstractBuilder<Builder> {
        public Builder(String providerName) {
            this.setProviderName(providerName);
        }

        public Builder(ProviderContext context) {
            super(context);
        }

        public Builder setProviderName(String providerName) {
            Objects.requireNonNull(providerName);
            this.set(providerName, (Object)ProviderAttribute.PROVIDER);
            return this;
        }

        public Builder setRateTypes(RateType ... rateTypes) {
            HashSet<RateType> types = new HashSet<RateType>();
            Objects.requireNonNull(rateTypes);
            if (rateTypes.length == 0) {
                throw new IllegalArgumentException("At least one RateType is required.");
            }
            types.addAll(Arrays.asList(rateTypes));
            this.set(types, (Object)ProviderAttribute.RATE_TYPES, Set.class);
            return this;
        }

        public Builder setValidFrom(long timestamp) {
            this.set(timestamp, (Object)ProviderAttribute.VALID_FROM);
            return this;
        }

        public Builder setValidFrom(Object dateTime) {
            this.set(dateTime, (Object)ProviderAttribute.VALID_FROM);
            return this;
        }

        public Builder setValidTo(long timestamp) {
            this.set(timestamp, (Object)ProviderAttribute.VALID_TO);
            return this;
        }

        public Builder setValidTo(Object dateTime) {
            this.set(dateTime, (Object)ProviderAttribute.VALID_TO);
            return this;
        }

        @Override
        public ProviderContext create() {
            return new ProviderContext(this);
        }
    }

    private static enum ProviderAttribute {
        PROVIDER,
        VALID_FROM,
        VALID_TO,
        RATE_TYPES;

    }
}

