/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.convert.ConversionContext;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryConversionsSpi;

public final class MonetaryConversions {
    private static final MonetaryConversionsSpi MONETARY_CONVERSION_SPI = Bootstrap.getService(MonetaryConversionsSpi.class);

    private MonetaryConversions() {
    }

    public static CurrencyConversion getConversion(CurrencyUnit termCurrency, String ... providers) {
        if (providers.length == 0) {
            return MONETARY_CONVERSION_SPI.getConversion(termCurrency, ConversionContext.of(), MonetaryConversions.getDefaultProviderChain().toArray(new String[0]));
        }
        return MONETARY_CONVERSION_SPI.getConversion(termCurrency, ConversionContext.of(), providers);
    }

    public static CurrencyConversion getConversion(String termCurrencyCode, String ... providers) {
        return MonetaryConversions.getConversion(MonetaryCurrencies.getCurrency(termCurrencyCode), providers);
    }

    public static CurrencyConversion getConversion(CurrencyUnit termCurrency, ConversionContext conversionContext, String ... providers) {
        if (providers.length == 0) {
            return MONETARY_CONVERSION_SPI.getConversion(termCurrency, conversionContext, MonetaryConversions.getDefaultProviderChain().toArray(new String[0]));
        }
        return MONETARY_CONVERSION_SPI.getConversion(termCurrency, ConversionContext.of(), providers);
    }

    public static CurrencyConversion getConversion(String termCurrencyCode, ConversionContext conversionContext, String ... providers) {
        return MonetaryConversions.getConversion(MonetaryCurrencies.getCurrency(termCurrencyCode), conversionContext, providers);
    }

    public static ExchangeRateProvider getExchangeRateProvider(String ... providers) {
        if (providers.length == 0) {
            return MONETARY_CONVERSION_SPI.getExchangeRateProvider(MonetaryConversions.getDefaultProviderChain().toArray(new String[0]));
        }
        ExchangeRateProvider provider = MONETARY_CONVERSION_SPI.getExchangeRateProvider(providers);
        if (provider == null) {
            throw new MonetaryException("No such rate provider: " + Arrays.toString(providers));
        }
        return provider;
    }

    public static Collection<String> getProviderNames() {
        Collection<String> providers = MONETARY_CONVERSION_SPI.getProviderNames();
        if (providers == null) {
            Logger.getLogger(MonetaryConversions.class.getName()).warning("No supported rate/conversion providers returned by SPI: " + MONETARY_CONVERSION_SPI.getClass().getName());
            return Collections.emptySet();
        }
        return providers;
    }

    public static ProviderContext getProviderContext(String provider) {
        ProviderContext ctx = MONETARY_CONVERSION_SPI.getProviderContext(provider);
        if (ctx == null) {
            throw new MonetaryException("No such rate provider: " + provider);
        }
        return ctx;
    }

    public static boolean isProviderAvailable(String provider) {
        return MONETARY_CONVERSION_SPI.isProviderAvailable(provider);
    }

    public static List<String> getDefaultProviderChain() {
        List<String> defaultChain = MONETARY_CONVERSION_SPI.getDefaultProviderChain();
        Objects.requireNonNull(defaultChain, "No default provider chain provided by SPI: " + MONETARY_CONVERSION_SPI.getClass().getName());
        return defaultChain;
    }
}

