/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.RateType;

public final class ExchangeRate
implements Serializable,
Comparable<ExchangeRate> {
    private static final long serialVersionUID = 5077295306570465837L;
    private final CurrencyUnit base;
    private final CurrencyUnit term;
    private final NumberValue factor;
    private final ConversionContext conversionContext;
    private ExchangeRate[] chain = new ExchangeRate[]{this};

    private ExchangeRate(Builder builder) {
        Objects.requireNonNull(builder.base, "base may not be null.");
        Objects.requireNonNull(builder.term, "term may not be null.");
        Objects.requireNonNull(builder.factor, "factor may not be null.");
        Objects.requireNonNull(builder.base, "exchangeRateType may not be null.");
        this.base = builder.base;
        this.term = builder.term;
        this.factor = builder.factor;
        this.conversionContext = builder.conversionContext;
        this.setExchangeRateChain(builder.rateChain);
    }

    private void setExchangeRateChain(ExchangeRate ... chain) {
        if (chain == null || chain.length == 0) {
            this.chain = new ExchangeRate[]{this};
        } else {
            for (int i = 0; i < chain.length; ++i) {
                if (chain[i] != null) continue;
                throw new IllegalArgumentException("Chain element can not be null.");
            }
            this.chain = chain;
        }
    }

    public final ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    public final CurrencyUnit getBase() {
        return this.base;
    }

    public final CurrencyUnit getTerm() {
        return this.term;
    }

    public final NumberValue getFactor() {
        return this.factor;
    }

    public final List<ExchangeRate> getExchangeRateChain() {
        return Arrays.asList(this.chain);
    }

    public final boolean isDerived() {
        return this.chain.length > 1;
    }

    @Override
    public int compareTo(ExchangeRate o) {
        if (o == null) {
            return -1;
        }
        int compare = this.getBase().getCurrencyCode().compareTo(o.getBase().getCurrencyCode());
        if (compare == 0) {
            compare = this.getTerm().getCurrencyCode().compareTo(o.getTerm().getCurrencyCode());
        }
        if (compare == 0) {
            compare = this.getConversionContext().getProvider().compareTo(o.getConversionContext().getProvider());
        }
        return compare;
    }

    public String toString() {
        return "ExchangeRate [base=" + this.base + ", factor=" + this.factor + ", conversionContext=" + this.conversionContext + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + (this.conversionContext == null ? 0 : this.conversionContext.hashCode());
        result = 31 * result + (this.factor == null ? 0 : this.factor.hashCode());
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        if (this.chain[0] != this) {
            result = 31 * result + Arrays.hashCode(this.chain);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExchangeRate other = (ExchangeRate)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.chain[0] != this && !Arrays.equals(this.chain, other.chain)) {
            return false;
        }
        if (this.conversionContext == null ? other.conversionContext != null : !this.conversionContext.equals(other.conversionContext)) {
            return false;
        }
        if (this.factor == null ? other.factor != null : !this.factor.equals(other.factor)) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    public Builder toBuilder() {
        return new Builder(this.getConversionContext()).setBase(this.getBase()).setTerm(this.getTerm()).setFactor(this.getFactor()).setRateChain(this.getExchangeRateChain().toArray(new ExchangeRate[0]));
    }

    public static class Builder {
        private ConversionContext conversionContext;
        private CurrencyUnit base;
        private CurrencyUnit term;
        private NumberValue factor;
        private ExchangeRate[] rateChain;

        public Builder(String provider, RateType rateType) {
            this(ConversionContext.of(provider, rateType));
        }

        public Builder(ConversionContext context) {
            this.setContext(context);
        }

        public Builder setBase(CurrencyUnit base) {
            this.base = base;
            return this;
        }

        public Builder setTerm(CurrencyUnit term) {
            this.term = term;
            return this;
        }

        public Builder setRateChain(ExchangeRate ... exchangeRates) {
            this.rateChain = exchangeRates != null ? (ExchangeRate[])exchangeRates.clone() : null;
            return this;
        }

        public Builder setFactor(NumberValue factor) {
            this.factor = factor;
            return this;
        }

        public Builder setContext(ConversionContext conversionContext) {
            Objects.requireNonNull(conversionContext);
            this.conversionContext = conversionContext;
            return this;
        }

        public ExchangeRate create() {
            return new ExchangeRate(this);
        }

        public Builder setRate(ExchangeRate rate) {
            this.base = rate.getBase();
            this.term = rate.getTerm();
            this.conversionContext = rate.getConversionContext();
            this.factor = rate.getFactor();
            this.rateChain = rate.chain;
            this.term = rate.getTerm();
            return this;
        }
    }
}

