/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.money.AbstractContext;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;

public final class ConversionContext
extends AbstractContext {
    public static final ConversionContext ANY_CONVERSION = new Builder().setRateType(RateType.ANY).create();
    public static final ConversionContext DEFERRED_CONVERSION = new Builder().setRateType(RateType.DEFERRED).create();
    public static final ConversionContext HISTORIC_CONVERSION = new Builder().setRateType(RateType.HISTORIC).create();
    public static final ConversionContext REALTIME_CONVERSION = new Builder().setRateType(RateType.REALTIME).create();
    public static final ConversionContext OTHER_CONVERSION = new Builder().setRateType(RateType.OTHER).create();

    private ConversionContext(Builder builder) {
        super(builder);
    }

    public RateType getRateType() {
        return this.getNamedAttribute(RateType.class, (Object)ConversionAttribute.RATE_TYPE, RateType.ANY);
    }

    public final Long getTimestamp() {
        return this.getNamedAttribute(Long.class, (Object)ConversionAttribute.TIMESTAMP, null);
    }

    public final <T> T getTimestamp(Class<T> type) {
        return this.getNamedAttribute(type, (Object)ConversionAttribute.TIMESTAMP, null);
    }

    public final Long getValidTo() {
        return this.getNamedAttribute(Long.class, (Object)ConversionAttribute.VALID_TO, null);
    }

    public final <T> T getValidTo(Class<T> type) {
        return this.getNamedAttribute(type, (Object)ConversionAttribute.VALID_TO, null);
    }

    public boolean isValid(long timestamp) {
        Long ts = this.getTimestamp();
        if (ts != null && ts > timestamp) {
            return false;
        }
        ts = this.getValidTo();
        return ts == null || ts >= timestamp;
    }

    public String getProvider() {
        return this.getNamedAttribute(String.class, (Object)ConversionAttribute.PROVIDER, null);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversionContext of(String provider, RateType rateType) {
        Builder b = new Builder();
        b.setRateType(rateType);
        b.setProvider(provider);
        return b.create();
    }

    public static ConversionContext of(RateType rateType) {
        switch (rateType) {
            default: {
                return ANY_CONVERSION;
            }
            case DEFERRED: {
                return DEFERRED_CONVERSION;
            }
            case HISTORIC: {
                return HISTORIC_CONVERSION;
            }
            case REALTIME: {
                return REALTIME_CONVERSION;
            }
            case OTHER: 
        }
        return OTHER_CONVERSION;
    }

    public static ConversionContext of() {
        return ANY_CONVERSION;
    }

    public static ConversionContext of(String provider, RateType rateType, Long timestamp) {
        if (timestamp == null) {
            return new Builder().setProvider(provider).setRateType(rateType).create();
        }
        return new Builder().setProvider(provider).setRateType(rateType).setTimestamp(timestamp).create();
    }

    public static final class Builder
    extends AbstractContext.AbstractBuilder<Builder> {
        public Builder() {
        }

        public Builder(ConversionContext context) {
            super(context);
        }

        public Builder(ProviderContext context, RateType rateType) {
            super(context);
            this.setRateType(rateType);
        }

        public Builder setTimestamp(long timestamp) {
            this.set(timestamp, (Object)ConversionAttribute.TIMESTAMP);
            return this;
        }

        public Builder setTimestamp(Object dateTime) {
            this.set(dateTime, (Object)ConversionAttribute.TIMESTAMP);
            if (dateTime instanceof Date) {
                this.setTimestamp(((Date)dateTime).getTime());
            } else if (dateTime instanceof Calendar) {
                this.setTimestamp(((Calendar)dateTime).getTime());
            }
            return this;
        }

        public Builder setValidTo(long timestamp) {
            this.set(timestamp, (Object)ConversionAttribute.VALID_TO);
            return this;
        }

        public Builder setValidTo(Object dateTime) {
            this.set(dateTime, (Object)ConversionAttribute.VALID_TO);
            if (dateTime instanceof Date) {
                this.setValidTo(((Date)dateTime).getTime());
            } else if (dateTime instanceof Calendar) {
                this.setValidTo(((Calendar)dateTime).getTime());
            }
            return this;
        }

        public Builder setRateType(RateType rateType) {
            Objects.requireNonNull(rateType);
            this.set((Object)rateType, (Object)ConversionAttribute.RATE_TYPE);
            return this;
        }

        public Builder setProvider(String provider) {
            Objects.requireNonNull(provider);
            this.set(provider, (Object)ConversionAttribute.PROVIDER);
            return this;
        }

        @Override
        public ConversionContext create() {
            return new ConversionContext(this);
        }
    }

    private static enum ConversionAttribute {
        PROVIDER,
        TIMESTAMP,
        VALID_TO,
        RATE_TYPE;

    }
}

