/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.spi.Bootstrap;
import javax.money.spi.RoundingProviderSpi;

public final class MonetaryRoundings {
    private static final MonetaryOperator DEFAULT_ROUNDING = new DefaultCurrencyRounding();

    private MonetaryRoundings() {
    }

    public static MonetaryOperator getRounding() {
        return DEFAULT_ROUNDING;
    }

    public static MonetaryOperator getRounding(MonetaryContext monetaryContext) {
        Objects.requireNonNull(monetaryContext, "MonetaryContext required.");
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                MonetaryOperator op = prov.getRounding(monetaryContext);
                if (op == null) continue;
                return op;
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryRoundings.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from ptovider: " + prov, e);
            }
        }
        throw new MonetaryException("No Rounding found matching " + monetaryContext);
    }

    public static MonetaryOperator getRounding(CurrencyUnit currency) {
        Objects.requireNonNull(currency, "Currency required.");
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                MonetaryOperator op = prov.getRounding(currency);
                if (op == null) continue;
                return op;
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryRoundings.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from ptovider: " + prov, e);
            }
        }
        throw new MonetaryException("No Rounding found for currency " + currency);
    }

    public static MonetaryOperator getCashRounding(CurrencyUnit currency) {
        Objects.requireNonNull(currency, "Currency required.");
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                MonetaryOperator op = prov.getCashRounding(currency);
                if (op == null) continue;
                return op;
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryRoundings.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from ptovider: " + prov, e);
            }
        }
        throw new MonetaryException("No Cash Rounding found for currency " + currency);
    }

    public static MonetaryOperator getRounding(CurrencyUnit currency, long timestamp) {
        Objects.requireNonNull(currency, "Currency required.");
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                MonetaryOperator op = prov.getRounding(currency, timestamp);
                if (op == null) continue;
                return op;
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryRoundings.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
            }
        }
        throw new MonetaryException("No Rounding found for currency " + currency + ", timestamp=" + timestamp);
    }

    public static MonetaryOperator getCashRounding(CurrencyUnit currency, long timestamp) {
        Objects.requireNonNull(currency, "Currency required.");
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                MonetaryOperator op = prov.getCashRounding(currency, timestamp);
                if (op == null) continue;
                return op;
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryRoundings.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from ptovider: " + prov, e);
            }
        }
        throw new MonetaryException("No Rounding found for currency " + currency + ", timestamp=" + timestamp);
    }

    public static MonetaryOperator getRounding(String customRoundingId) {
        Objects.requireNonNull(customRoundingId, "CustomRoundingId required.");
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                MonetaryOperator op = prov.getCustomRounding(customRoundingId);
                if (op == null) continue;
                return op;
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryRoundings.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
            }
        }
        throw new MonetaryException("No Custom Rounding found with id " + customRoundingId);
    }

    public static Set<String> getCustomRoundingIds() {
        HashSet<String> result = new HashSet<String>();
        for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
            try {
                result.addAll(prov.getCustomRoundingIds());
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryRoundings.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
            }
        }
        return result;
    }

    private static final class DefaultCurrencyRounding
    implements MonetaryOperator {
        private DefaultCurrencyRounding() {
        }

        @Override
        public <T extends MonetaryAmount> T apply(T amount) {
            MonetaryOperator r = MonetaryRoundings.getRounding(amount.getCurrency());
            return r.apply(amount);
        }
    }
}

