/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.UnknownCurrencyException;
import javax.money.spi.Bootstrap;
import javax.money.spi.CurrencyProviderSpi;

public final class MonetaryCurrencies {
    private MonetaryCurrencies() {
    }

    public static CurrencyUnit getCurrency(String currencyCode) {
        CurrencyUnit cu = null;
        for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            try {
                cu = spi.getCurrencyUnit(currencyCode);
                if (cu == null) continue;
                if (!currencyCode.equals(cu.getCurrencyCode())) {
                    throw new IllegalStateException("Provider(" + spi.getClass().getName() + ") returned an invalid CurrencyUnit for '" + currencyCode + "': " + cu.getCurrencyCode());
                }
                return cu;
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryCurrencies.class.getName()).log(Level.SEVERE, "Error loading Currency '" + currencyCode + "' from provider: " + spi.getClass().getName(), e);
            }
        }
        if (cu == null) {
            throw new UnknownCurrencyException(currencyCode);
        }
        return cu;
    }

    public static CurrencyUnit getCurrency(Locale locale) {
        CurrencyUnit cu = null;
        for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            try {
                cu = spi.getCurrencyUnit(locale);
                if (cu == null) continue;
                return cu;
            }
            catch (Exception e) {
                Logger.getLogger(MonetaryCurrencies.class.getName()).log(Level.SEVERE, "Error loading Currency for Locale '" + locale + " from provider: " + spi.getClass().getName(), e);
            }
        }
        throw new UnknownCurrencyException(locale);
    }

    public static boolean isCurrencyAvailable(String code) {
        try {
            MonetaryCurrencies.getCurrency(code);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCurrencyAvailable(Locale locale) {
        try {
            MonetaryCurrencies.getCurrency(locale);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

