/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Objects;
import javax.money.AbstractContext;
import javax.money.MonetaryAmount;

public final class MonetaryContext
extends AbstractContext
implements Serializable {
    private static final String AMOUNT_FLAVOR_KEY = "amountFlavor";
    private static final String AMOUNT_TYPE_KEY = "amountType";
    private static final String MAX_SCALE_KEY = "maxScale";
    private static final String FIXED_SCALE_KEY = "fixedScale";
    private static final String PRECISION_KEY = "precision";
    private static final long serialVersionUID = 5579720004786848255L;
    private final int precision;
    private final Class<? extends MonetaryAmount> amountType;
    private final AmountFlavor flavor;
    private final boolean fixedScale;
    private final int maxScale;

    private MonetaryContext(Builder builder) {
        super(builder);
        if (builder.precision < 0) {
            throw new IllegalArgumentException("precision < 0");
        }
        if (builder.maxScale < -1) {
            throw new IllegalArgumentException("maxScale < -1");
        }
        this.precision = builder.precision;
        this.fixedScale = builder.fixedScale;
        this.maxScale = builder.maxScale;
        this.amountType = builder.amountType;
        this.flavor = builder.amountFlavor;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isFixedScale() {
        return this.fixedScale;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public Class<? extends MonetaryAmount> getAmountType() {
        return this.amountType;
    }

    public AmountFlavor getAmountFlavor() {
        return this.flavor;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.fixedScale ? 1231 : 1237);
        result = 31 * result + this.maxScale;
        result = 31 * result + (this.amountType == null ? 0 : this.amountType.hashCode());
        result = 31 * result + (this.flavor == null ? 0 : this.flavor.hashCode());
        result = 31 * result + this.precision;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonetaryContext other = (MonetaryContext)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.fixedScale != other.fixedScale) {
            return false;
        }
        if (this.maxScale != other.maxScale) {
            return false;
        }
        if (this.amountType == null ? other.amountType != null : !this.amountType.equals(other.amountType)) {
            return false;
        }
        if (this.flavor == null ? other.flavor != null : !this.flavor.equals((Object)other.flavor)) {
            return false;
        }
        return this.precision == other.precision;
    }

    public static MonetaryContext from(MonetaryContext context, Class<? extends MonetaryAmount> amountType) {
        return new Builder(context).setAmountType(amountType).create();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.precision < 0) {
            String message = "NumericContext: invalid digits in stream";
            throw new StreamCorruptedException(message);
        }
    }

    @Override
    public String toString() {
        return "MonetaryContext [amountType=" + this.amountType + ", flavor=" + (Object)((Object)this.flavor) + ", precision=" + this.precision + ", maxScale=" + this.maxScale + ", fixedScale=" + this.fixedScale + ", attributes=" + this.attributes + "]";
    }

    public static final class Builder
    extends AbstractContext.AbstractBuilder<Builder> {
        private int precision = 0;
        private Class<? extends MonetaryAmount> amountType;
        private AmountFlavor amountFlavor = AmountFlavor.UNDEFINED;
        private boolean fixedScale;
        private int maxScale = -1;

        public Builder(Class<? extends MonetaryAmount> amountType) {
            Objects.requireNonNull(amountType);
            this.amountType = amountType;
        }

        public Builder() {
            this.amountType = MonetaryAmount.class;
        }

        public Builder(MonetaryContext context) {
            super(context);
            this.amountType = context.getAmountType();
            this.maxScale = context.getMaxScale();
            this.fixedScale = context.isFixedScale();
            this.precision = context.getPrecision();
            this.amountFlavor = context.getAmountFlavor();
        }

        public Builder setAmountType(Class<? extends MonetaryAmount> amountType) {
            Objects.requireNonNull(amountType);
            this.amountType = amountType;
            return this;
        }

        public Builder setPrecision(int precision) {
            if (precision < 0) {
                throw new IllegalArgumentException("precision < -1");
            }
            this.precision = precision;
            return this;
        }

        public Builder setFixedScale(boolean fixedScale) {
            this.fixedScale = fixedScale;
            return this;
        }

        public Builder setFlavor(AmountFlavor flavor) {
            Objects.requireNonNull(flavor);
            this.amountFlavor = flavor;
            return this;
        }

        public Builder setMaxScale(int maxScale) {
            if (maxScale < -1) {
                throw new IllegalArgumentException("maxScale < -1");
            }
            this.maxScale = maxScale;
            return this;
        }

        @Override
        public MonetaryContext create() {
            return new MonetaryContext(this);
        }

        @Override
        public String toString() {
            return "MonetaryContext.Builder [amountType=" + this.amountType + ", precision=" + this.precision + ", maxScale=" + this.maxScale + ", fixedScale=" + this.fixedScale + ", attributes=" + this.attributes + "]";
        }
    }

    public static enum AmountFlavor {
        PRECISION,
        PERFORMANCE,
        UNDEFINED;

    }
}

